/*
 * Decompiled with CFR 0.152.
 */
package org.revenj.database.postgres.converters;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.revenj.database.postgres.PostgresBuffer;
import org.revenj.database.postgres.PostgresReader;
import org.revenj.database.postgres.converters.PostgresTuple;
import org.revenj.database.postgres.converters.StringConverter;
import org.revenj.database.postgres.converters.ValueTuple;

public abstract class UrlConverter {
    public static void serializeURI(PostgresBuffer sw, URI value) throws IOException {
        if (value == null) {
            return;
        }
        sw.addToBuffer(value.toString());
    }

    public static URI parse(PostgresReader reader, int context) throws IOException {
        String value = StringConverter.parse(reader, context, true);
        return value != null ? URI.create(value) : null;
    }

    public static List<URI> parseCollection(PostgresReader reader, int context) throws IOException {
        boolean escaped;
        int cur = reader.read();
        if (cur == 44 || cur == 41) {
            return null;
        }
        boolean bl = escaped = cur != 123;
        if (escaped) {
            reader.read(context);
        }
        if ((cur = reader.peek()) == 125) {
            if (escaped) {
                reader.read(context + 2);
            } else {
                reader.read(2);
            }
            return new ArrayList<URI>(0);
        }
        int innerContext = context << 1;
        ArrayList<URI> list = new ArrayList<URI>();
        do {
            if ((cur = reader.read()) == 34 || cur == 92) {
                String url = StringConverter.parseEscapedString(reader, innerContext, '}');
                list.add(URI.create(url));
                cur = reader.last();
                continue;
            }
            reader.initBuffer((char)cur);
            reader.fillUntil(',', '}');
            cur = reader.read();
            if (reader.bufferMatches("NULL")) {
                list.add(null);
                continue;
            }
            list.add(URI.create(reader.bufferToString()));
        } while (cur == 44);
        if (escaped) {
            reader.read(context + 1);
        } else {
            reader.read();
        }
        return list;
    }

    public static PostgresTuple toTuple(URI value) {
        return value != null ? ValueTuple.from(value.toString()) : null;
    }
}

