/*
 * Decompiled with CFR 0.152.
 */
package org.revenj.database.postgres.converters;

import org.revenj.database.postgres.PostgresWriter;
import org.revenj.database.postgres.converters.PostgresTuple;

public class ValueTuple
extends PostgresTuple {
    public static final PostgresTuple EMPTY = new EmptyValueTuple();
    private final String value;
    private final boolean hasMarkers;
    private final boolean escapeRecord;
    private final boolean escapeArray;

    public ValueTuple(String value) {
        this.value = value;
        if (value != null) {
            boolean hasMarkers = false;
            boolean escapeRecord = value.length() == 0;
            boolean escapeArray = value.length() == 0 || value.equals("NULL");
            boolean hasWhitespace = false;
            for (int i = 0; i < value.length(); ++i) {
                char c = value.charAt(i);
                if (c == '\\' || c == '\"') {
                    escapeArray = true;
                    escapeRecord = true;
                    hasMarkers = true;
                    break;
                }
                if (c == ',') {
                    escapeArray = true;
                    escapeRecord = true;
                    continue;
                }
                if (c == '(' || c == ')') {
                    escapeRecord = true;
                    continue;
                }
                if (c == '{' || c == '}') {
                    escapeArray = true;
                    continue;
                }
                if (hasWhitespace) continue;
                hasWhitespace = Character.isWhitespace(c);
            }
            this.hasMarkers = hasMarkers;
            this.escapeRecord = hasMarkers || escapeRecord || hasWhitespace;
            this.escapeArray = hasMarkers || escapeArray || hasWhitespace;
        } else {
            this.escapeRecord = false;
            this.escapeArray = true;
            this.hasMarkers = false;
        }
    }

    public static PostgresTuple from(String value) {
        if (value == null) {
            return null;
        }
        if (value.length() == 0) {
            return EMPTY;
        }
        return new ValueTuple(value);
    }

    public ValueTuple(String value, boolean record, boolean array) {
        this.value = value;
        this.escapeRecord = record;
        this.escapeArray = array;
        this.hasMarkers = record || array;
    }

    @Override
    public boolean mustEscapeRecord() {
        return this.escapeRecord;
    }

    @Override
    public boolean mustEscapeArray() {
        return this.escapeArray;
    }

    @Override
    public String buildTuple(boolean quote) {
        if (this.value == null) {
            return "NULL";
        }
        return quote ? "'" + this.value.replace("'", "''") + "'" : this.value;
    }

    private void escape(PostgresWriter sw, String escaping, PostgresTuple.Mapping mappings) {
        String quoteEscape = null;
        String slashEscape = null;
        if (mappings != null) {
            for (int i = 0; i < this.value.length(); ++i) {
                int x;
                char c = this.value.charAt(i);
                if (c == '\"') {
                    quoteEscape = quoteEscape != null ? quoteEscape : ValueTuple.buildQuoteEscape(escaping);
                    for (x = 0; x < quoteEscape.length(); ++x) {
                        mappings.map(sw, quoteEscape.charAt(x));
                    }
                    continue;
                }
                if (c == '\\') {
                    slashEscape = slashEscape != null ? slashEscape : ValueTuple.buildSlashEscape(escaping.length());
                    for (x = 0; x < slashEscape.length(); ++x) {
                        mappings.map(sw, slashEscape.charAt(x));
                    }
                    continue;
                }
                mappings.map(sw, c);
            }
        } else {
            for (int i = 0; i < this.value.length(); ++i) {
                char c = this.value.charAt(i);
                if (c == '\"') {
                    quoteEscape = quoteEscape != null ? quoteEscape : ValueTuple.buildQuoteEscape(escaping);
                    sw.write(quoteEscape);
                    continue;
                }
                if (c == '\\') {
                    slashEscape = slashEscape != null ? slashEscape : ValueTuple.buildSlashEscape(escaping.length());
                    sw.write(slashEscape);
                    continue;
                }
                sw.write(c);
            }
        }
    }

    @Override
    public void insertRecord(PostgresWriter sw, String escaping, PostgresTuple.Mapping mappings) {
        if (this.hasMarkers) {
            this.escape(sw, escaping, mappings);
        } else if (mappings != null) {
            for (int x = 0; x < this.value.length(); ++x) {
                mappings.map(sw, this.value.charAt(x));
            }
        } else if (this.value != null) {
            sw.write(this.value);
        }
    }

    @Override
    public void insertArray(PostgresWriter sw, String escaping, PostgresTuple.Mapping mappings) {
        if (this.value == null) {
            sw.write("NULL");
        } else if (this.hasMarkers) {
            this.escape(sw, escaping, mappings);
        } else if (mappings != null) {
            for (int x = 0; x < this.value.length(); ++x) {
                mappings.map(sw, this.value.charAt(x));
            }
        } else {
            sw.write(this.value);
        }
    }

    static class EmptyValueTuple
    extends PostgresTuple {
        EmptyValueTuple() {
        }

        @Override
        public boolean mustEscapeRecord() {
            return true;
        }

        @Override
        public boolean mustEscapeArray() {
            return true;
        }

        @Override
        public void insertRecord(PostgresWriter sw, String escaping, PostgresTuple.Mapping mappings) {
        }

        @Override
        public String buildTuple(boolean quote) {
            return quote ? "'\"\"'" : "\"\"";
        }
    }
}

