/*
 * Decompiled with CFR 0.152.
 */
package org.revenj.database.postgres.jinq;

import ch.epfl.labos.iu.orm.queryll2.symbolic.MethodSignature;
import ch.epfl.labos.iu.orm.queryll2.symbolic.TypedValue;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Optional;
import javax.sql.DataSource;
import org.revenj.database.postgres.QueryProvider;
import org.revenj.database.postgres.jinq.RevenjQueryProvider;
import org.revenj.database.postgres.jinq.transform.MetamodelUtil;
import org.revenj.extensibility.Container;
import org.revenj.patterns.Query;

public final class JinqMetaModel
extends MetamodelUtil {
    private final HashMap<Class<?>, String> classSources = new HashMap();
    private final HashMap<String, String> stringSources = new HashMap();
    private final HashMap<Method, Query.Compare> methodGetters = new HashMap();

    private JinqMetaModel() {
        this.safeMethods.add(new MethodSignature("java/lang/ThreadLocal", "get", "()Ljava/lang/Object;"));
    }

    public static JinqMetaModel configure(Container container) {
        Optional<JinqMetaModel> tryModel = container.tryResolve(JinqMetaModel.class);
        if (tryModel.isPresent()) {
            return tryModel.get();
        }
        JinqMetaModel metamodel = new JinqMetaModel();
        container.registerInstance((Type)((Object)MetamodelUtil.class), metamodel, false);
        container.registerInstance((Type)((Object)JinqMetaModel.class), metamodel, false);
        DataSource dataSource = container.resolve(DataSource.class);
        ClassLoader loader = container.resolve(ClassLoader.class);
        container.registerInstance((Type)((Object)QueryProvider.class), new RevenjQueryProvider(metamodel, loader, dataSource), false);
        return metamodel;
    }

    public <T, V> void registerProperty(Class<?> clazz, String methodName, String property, Query.Compare<T, V> getter) throws IOException {
        try {
            Method method = clazz.getMethod(methodName, new Class[0]);
            this.addProperty(method, property);
            this.methodGetters.put(method, getter);
        }
        catch (NoSuchMethodException e) {
            throw new IOException(e);
        }
    }

    public void registerStatic(Class<?> clazz, String methodName, String function) throws IOException {
        try {
            this.addStatic(clazz.getMethod(methodName, new Class[0]), function);
        }
        catch (NoSuchMethodException e) {
            throw new IOException(e);
        }
    }

    public void registerDataSource(Class<?> clazz, String dataSource) {
        this.classSources.put(clazz, dataSource);
        this.stringSources.put(clazz.getCanonicalName(), dataSource);
        String sourceTypeName = org.jinq.rebased.org.objectweb.asm.Type.getInternalName(clazz);
        MethodSignature eqMethod = new MethodSignature(sourceTypeName, "equals", "(Ljava/lang/Object;)Z");
        this.comparisonMethods.put(eqMethod, TypedValue.ComparisonValue.ComparisonOp.eq);
        this.comparisonMethodsWithObjectEquals.put(eqMethod, TypedValue.ComparisonValue.ComparisonOp.eq);
        this.safeMethods.add(eqMethod);
    }

    public Query.Compare findGetter(Method method) {
        return this.methodGetters.get(method);
    }

    @Override
    public <U> String dataSourceNameFromClass(Class<U> dataSource) {
        return this.classSources.get(dataSource);
    }

    @Override
    public String dataSourceNameFromClassName(String className) {
        return this.stringSources.get(className);
    }

    public Iterable<Class<?>> dataSources() {
        return this.classSources.keySet();
    }
}

