/*
 * Decompiled with CFR 0.152.
 */
package org.revenj.database.postgres.jinq;

import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import java.util.Optional;
import org.revenj.database.postgres.jinq.RevenjQueryComposer;
import org.revenj.database.postgres.jinq.transform.LambdaInfo;
import org.revenj.patterns.DataSource;
import org.revenj.patterns.Query;
import org.revenj.patterns.Specification;

final class RevenjQuery<T extends DataSource>
implements Query<T> {
    private final RevenjQueryComposer<T> queryComposer;

    public RevenjQuery(RevenjQueryComposer<T> query) {
        this.queryComposer = query;
    }

    static <U extends DataSource> RevenjQuery<U> makeQueryStream(RevenjQueryComposer<U> query) {
        return new RevenjQuery<U>(query);
    }

    private RevenjQueryComposer applyWhere(Specification predicate) {
        if (predicate == null) {
            return this.queryComposer;
        }
        return this.queryComposer.where(LambdaInfo.analyze(this.queryComposer.rewrite(predicate), this.queryComposer.getLambdaCount(), true));
    }

    private RevenjQueryComposer applyOrder(Query.Compare order, boolean ascending) {
        return this.queryComposer.sortedBy(LambdaInfo.analyze(order, this.queryComposer.getLambdaCount(), true), ascending);
    }

    @Override
    public Query<T> filter(Specification<T> predicate) {
        if (predicate == null) {
            return this;
        }
        return RevenjQuery.makeQueryStream(this.applyWhere(predicate));
    }

    @Override
    public Query<T> skip(long n) {
        RevenjQueryComposer<T> newComposer = this.queryComposer.skip(n);
        return RevenjQuery.makeQueryStream(newComposer);
    }

    @Override
    public Query<T> limit(long n) {
        RevenjQueryComposer<T> newComposer = this.queryComposer.limit(n);
        return RevenjQuery.makeQueryStream(newComposer);
    }

    @Override
    public <V> Query<T> sortedBy(Query.Compare<T, V> order) {
        return RevenjQuery.makeQueryStream(this.applyOrder(order, true));
    }

    @Override
    public <V> Query<T> sortedDescendingBy(Query.Compare<T, V> order) {
        return RevenjQuery.makeQueryStream(this.applyOrder(order, false));
    }

    @Override
    public long count() throws IOException {
        try {
            return this.queryComposer.count();
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    @Override
    public boolean anyMatch(Specification<? super T> predicate) throws IOException {
        try {
            return this.applyWhere(predicate).any();
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    @Override
    public boolean allMatch(Specification<? super T> predicate) throws IOException {
        try {
            LambdaInfo lambda = LambdaInfo.analyze(this.queryComposer.rewrite(predicate), this.queryComposer.getLambdaCount(), true);
            return this.queryComposer.all(lambda);
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    @Override
    public boolean noneMatch(Specification<? super T> predicate) throws IOException {
        try {
            return this.applyWhere(predicate).none();
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    @Override
    public Optional<T> findFirst() throws IOException {
        try {
            return this.queryComposer.first();
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    @Override
    public Optional<T> findAny() throws IOException {
        try {
            return this.queryComposer.first();
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    @Override
    public List<T> list() throws IOException {
        try {
            return this.queryComposer.toList();
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }
}

