/*
 * Decompiled with CFR 0.152.
 */
package org.revenj.database.postgres.jinq;

import java.io.IOException;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import org.postgresql.util.PGobject;
import org.revenj.Utils;
import org.revenj.database.postgres.ObjectConverter;
import org.revenj.database.postgres.PostgresBuffer;
import org.revenj.database.postgres.PostgresReader;
import org.revenj.database.postgres.PostgresWriter;
import org.revenj.database.postgres.converters.ArrayTuple;
import org.revenj.database.postgres.converters.PostgresTuple;
import org.revenj.database.postgres.converters.TimestampConverter;
import org.revenj.database.postgres.jinq.RevenjQuery;
import org.revenj.database.postgres.jinq.RevenjQueryComposerCache;
import org.revenj.database.postgres.jinq.jpqlquery.GeneratedQueryParameter;
import org.revenj.database.postgres.jinq.jpqlquery.JinqPostgresQuery;
import org.revenj.database.postgres.jinq.transform.LambdaAnalysis;
import org.revenj.database.postgres.jinq.transform.LambdaInfo;
import org.revenj.database.postgres.jinq.transform.LimitSkipTransform;
import org.revenj.database.postgres.jinq.transform.MetamodelUtil;
import org.revenj.database.postgres.jinq.transform.QueryTransformException;
import org.revenj.database.postgres.jinq.transform.RevenjMultiLambdaQueryTransform;
import org.revenj.database.postgres.jinq.transform.RevenjNoLambdaQueryTransform;
import org.revenj.database.postgres.jinq.transform.RevenjOneLambdaQueryTransform;
import org.revenj.database.postgres.jinq.transform.RevenjQueryTransformConfiguration;
import org.revenj.database.postgres.jinq.transform.SortingTransform;
import org.revenj.database.postgres.jinq.transform.WhereTransform;
import org.revenj.patterns.DataSource;
import org.revenj.patterns.ServiceLocator;
import org.revenj.patterns.Specification;

public final class RevenjQueryComposer<T> {
    private static final Map<Class<?>, String> typeMapping = new HashMap();
    private static final Map<String, Integer> sqlIdMapping = new HashMap<String, Integer>();
    private final MetamodelUtil metamodel;
    private final ClassLoader loader;
    private final RevenjQueryComposerCache cachedQueries;
    private final Connection connection;
    private final ServiceLocator locator;
    private final GetConnection getConnection;
    private final ReleaseConnection releaseConnection;
    private final JinqPostgresQuery<T> query;
    private final Class<T> manifest;
    private final List<LambdaInfo> lambdas = new ArrayList<LambdaInfo>();
    private static final PGobject EMPTY_ARRAY;
    private static final ConcurrentMap<Class<?>, Optional<ObjectConverter>> objectConverters;
    private RevenjQueryTransformConfiguration transformationConfig = null;

    private static void addMapping(Class<?> manifest, String dbType, int oid, int sqlId) {
        typeMapping.put(manifest, dbType);
        sqlIdMapping.put(manifest.getName(), sqlId);
    }

    public int getLambdaCount() {
        return this.lambdas.size();
    }

    private RevenjQueryComposer(RevenjQueryComposer<?> base, Class<T> manifest, JinqPostgresQuery<T> query, List<LambdaInfo> chainedLambdas, LambdaInfo ... additionalLambdas) {
        this(base.metamodel, base.loader, manifest, base.cachedQueries, base.connection, base.locator, base.getConnection, base.releaseConnection, query, chainedLambdas, additionalLambdas);
    }

    private RevenjQueryComposer(MetamodelUtil metamodel, ClassLoader loader, Class<T> manifest, RevenjQueryComposerCache cachedQueries, Connection connection, ServiceLocator locator, GetConnection getConnection, ReleaseConnection releaseConnection, JinqPostgresQuery<T> query, List<LambdaInfo> chainedLambdas, LambdaInfo ... additionalLambdas) {
        this.metamodel = metamodel;
        this.loader = loader;
        this.manifest = manifest;
        this.cachedQueries = cachedQueries;
        this.connection = connection;
        this.locator = locator;
        this.getConnection = getConnection;
        this.releaseConnection = releaseConnection;
        this.query = query;
        this.lambdas.addAll(chainedLambdas);
        for (LambdaInfo newLambda : additionalLambdas) {
            this.lambdas.add(newLambda);
        }
    }

    public static <T extends DataSource> RevenjQuery<T> findAll(MetamodelUtil metamodel, ClassLoader loader, Class<T> manifest, RevenjQueryComposerCache cachedQueries, Connection conn, ServiceLocator locator, GetConnection getConnection, ReleaseConnection releaseConnection) {
        String sqlSource = metamodel.dataSourceNameFromClass(manifest);
        Optional<JinqPostgresQuery<Object>> cachedQuery = cachedQueries.findCachedFindAll(sqlSource);
        if (cachedQuery == null) {
            JinqPostgresQuery query = JinqPostgresQuery.findAll(sqlSource);
            cachedQuery = Optional.of(query);
            cachedQuery = cachedQueries.cacheFindAll(sqlSource, cachedQuery);
        }
        JinqPostgresQuery<?> findAllQuery = cachedQuery.get();
        RevenjQueryComposer<T> queryComposer = new RevenjQueryComposer<T>(metamodel, loader, manifest, cachedQueries, conn, locator, getConnection, releaseConnection, findAllQuery, new ArrayList<LambdaInfo>(), new LambdaInfo[0]);
        return new RevenjQuery<T>(queryComposer);
    }

    private static String getTypeFor(Class<?> manifest) {
        return typeMapping.get(manifest);
    }

    private static String getElementTypeFor(Object[] elements) {
        for (Object item : elements) {
            String type;
            if (item == null || (type = RevenjQueryComposer.getTypeFor(item.getClass())) == null) continue;
            return type;
        }
        return "unknown";
    }

    public static void fillQueryParameters(Connection connection, ServiceLocator locator, PreparedStatement ps, int parameterOffset, List<GeneratedQueryParameter> parameters, List<LambdaInfo> lambdas) throws SQLException {
        PostgresWriter writer = null;
        for (int i = 0; i < parameters.size(); ++i) {
            Object converter;
            Class<?> manifest;
            GeneratedQueryParameter param = parameters.get(i);
            Object value = param.getValue.apply(lambdas.get(param.lambdaIndex));
            if (value == null) {
                Integer sqlId = sqlIdMapping.get(param.javaType);
                if (sqlId == null || sqlId == -1) {
                    if (param.sqlType != null) {
                        PGobject pgo = new PGobject();
                        pgo.setType(param.sqlType);
                        pgo.setValue("null");
                        ps.setObject(i + 1 + parameterOffset, pgo);
                        continue;
                    }
                    ps.setObject(i + 1 + parameterOffset, null);
                    continue;
                }
                ps.setNull(i + 1 + parameterOffset, sqlId);
                continue;
            }
            Object[] elements = null;
            if (value instanceof Collection) {
                Collection collection = (Collection)value;
                elements = new Object[collection.size()];
                int x = 0;
                for (Object item : collection) {
                    elements[x++] = item;
                }
            } else if (value instanceof Object[]) {
                elements = (Object[])value;
            }
            if (elements == null) {
                manifest = value.getClass();
                converter = RevenjQueryComposer.getConverterFor(locator, manifest);
                if (((Optional)converter).isPresent()) {
                    PGobject pgo = new PGobject();
                    if (writer == null) {
                        writer = PostgresWriter.create();
                    }
                    writer.reset();
                    PostgresTuple tuple = ((ObjectConverter)((Optional)converter).get()).to(value);
                    tuple.buildTuple(writer, false);
                    pgo.setValue(writer.toString());
                    pgo.setType(((ObjectConverter)((Optional)converter).get()).getDbName());
                    ps.setObject(i + 1 + parameterOffset, pgo);
                    continue;
                }
                if (value instanceof LocalDate) {
                    ps.setDate(i + 1 + parameterOffset, Date.valueOf((LocalDate)value));
                    continue;
                }
                if (value instanceof LocalDateTime) {
                    if (writer == null) {
                        writer = PostgresWriter.create();
                    }
                    TimestampConverter.setParameter((PostgresBuffer)writer, ps, i + 1, (LocalDateTime)value);
                    continue;
                }
                if (value instanceof OffsetDateTime) {
                    if (writer == null) {
                        writer = PostgresWriter.create();
                    }
                    TimestampConverter.setParameter((PostgresBuffer)writer, ps, i + 1, (OffsetDateTime)value);
                    continue;
                }
                ps.setObject(i + 1 + parameterOffset, value);
                continue;
            }
            manifest = null;
            converter = elements;
            int pgo = ((Object[])converter).length;
            for (int tuple = 0; tuple < pgo; ++tuple) {
                Object item = converter[tuple];
                if (item == null) continue;
                manifest = item.getClass();
                break;
            }
            Object object = converter = manifest != null ? RevenjQueryComposer.getConverterFor(locator, manifest) : Optional.empty();
            if (((Optional)converter).isPresent()) {
                ObjectConverter oc = (ObjectConverter)((Optional)converter).get();
                if (writer == null) {
                    writer = PostgresWriter.create();
                }
                writer.reset();
                PostgresTuple tuple = ArrayTuple.create(elements, oc::to);
                PGobject pgo2 = new PGobject();
                pgo2.setType(oc.getDbName() + "[]");
                tuple.buildTuple(writer, false);
                pgo2.setValue(writer.toString());
                ps.setObject(i + 1 + parameterOffset, pgo2);
                continue;
            }
            String type = RevenjQueryComposer.getElementTypeFor(elements);
            if ("unknown".equals(type) && elements.length == 0) {
                if (param.sqlType != null) {
                    PGobject pgo3 = new PGobject();
                    pgo3.setType(param.sqlType);
                    pgo3.setValue("{}");
                    ps.setObject(i + 1 + parameterOffset, pgo3);
                    continue;
                }
                ps.setObject(i + 1 + parameterOffset, EMPTY_ARRAY);
                continue;
            }
            Array array = connection.createArrayOf(type, elements);
            ps.setArray(i + 1 + parameterOffset, array);
        }
        if (writer != null) {
            writer.close();
        }
    }

    private static Optional<ObjectConverter> getConverterFor(ServiceLocator locator, Class<?> manifest) {
        return objectConverters.computeIfAbsent(manifest, clazz -> {
            try {
                ObjectConverter result = (ObjectConverter)locator.resolve(Utils.makeGenericType(ObjectConverter.class, clazz, new Type[0]));
                return Optional.of(result);
            }
            catch (Exception ignore) {
                return Optional.empty();
            }
        });
    }

    private Connection getConnection() throws SQLException {
        if (this.connection != null) {
            return this.connection;
        }
        return this.getConnection.get();
    }

    private void releaseConnection(Connection connection) throws SQLException {
        if (this.connection == null) {
            this.releaseConnection.release(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long count() throws SQLException {
        String queryString = this.query.getQueryString();
        Connection connection = this.getConnection();
        try (PreparedStatement ps = connection.prepareStatement("SELECT COUNT(*) FROM (" + queryString + ") sq");){
            RevenjQueryComposer.fillQueryParameters(connection, this.locator, ps, 0, this.query.getQueryParameters(), this.lambdas);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    long l = rs.getLong(1);
                    return l;
                }
            }
        }
        finally {
            this.releaseConnection(connection);
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean any() throws SQLException {
        String queryString = this.query.getQueryString();
        Connection connection = this.getConnection();
        try (PreparedStatement ps = connection.prepareStatement("SELECT EXISTS(" + queryString + ")");){
            RevenjQueryComposer.fillQueryParameters(connection, this.locator, ps, 0, this.query.getQueryParameters(), this.lambdas);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    boolean bl = rs.getBoolean(1);
                    return bl;
                }
            }
        }
        finally {
            this.releaseConnection(connection);
        }
        return false;
    }

    public boolean all(LambdaInfo lambda) throws SQLException {
        long all;
        long filter = this.where(lambda).count();
        return filter == (all = this.count()) && all > 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean none() throws SQLException {
        String queryString = this.query.getQueryString();
        Connection connection = this.getConnection();
        try (PreparedStatement ps = connection.prepareStatement("SELECT NOT EXISTS(" + queryString + ")");){
            RevenjQueryComposer.fillQueryParameters(connection, this.locator, ps, 0, this.query.getQueryParameters(), this.lambdas);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    boolean bl = rs.getBoolean(1);
                    return bl;
                }
            }
        }
        finally {
            this.releaseConnection(connection);
        }
        return true;
    }

    public Optional<T> first() throws SQLException {
        String queryString = this.query.getQueryString();
        Connection connection = this.getConnection();
        try (PreparedStatement ps = connection.prepareStatement(queryString);){
            RevenjQueryComposer.fillQueryParameters(connection, this.locator, ps, 0, this.query.getQueryParameters(), this.lambdas);
            PostgresReader pr = new PostgresReader(this.locator);
            try {
                ObjectConverter converter = RevenjQueryComposer.getConverterFor(this.locator, this.manifest).get();
                try (ResultSet rs = ps.executeQuery();){
                    if (rs.next()) {
                        pr.process(rs.getString(1));
                        Optional optional = Optional.of(converter.from(pr));
                        return optional;
                    }
                }
            }
            catch (IOException e) {
                throw new SQLException(e);
            }
            finally {
                this.releaseConnection(connection);
            }
            Optional optional = Optional.empty();
            return optional;
        }
    }

    public List<T> toList() throws SQLException {
        String queryString = this.query.getQueryString();
        Connection connection = this.getConnection();
        try (PreparedStatement ps = connection.prepareStatement(queryString);){
            RevenjQueryComposer.fillQueryParameters(connection, this.locator, ps, 0, this.query.getQueryParameters(), this.lambdas);
            PostgresReader pr = new PostgresReader(this.locator);
            ArrayList result = new ArrayList();
            try {
                ObjectConverter converter = RevenjQueryComposer.getConverterFor(this.locator, this.manifest).get();
                try (ResultSet rs = ps.executeQuery();){
                    while (rs.next()) {
                        pr.process(rs.getString(1));
                        result.add(converter.from(pr));
                    }
                }
            }
            catch (IOException e) {
                throw new SQLException(e);
            }
            finally {
                this.releaseConnection(connection);
            }
            ArrayList arrayList = result;
            return arrayList;
        }
    }

    private <U> RevenjQueryComposer<U> applyTransformWithLambda(Class<U> newManifest, RevenjNoLambdaQueryTransform transform) {
        Optional<JinqPostgresQuery<Object>> cachedQuery = this.cachedQueries.findInCache(this.query, transform.getTransformationTypeCachingTag(), null);
        if (cachedQuery == null) {
            cachedQuery = Optional.empty();
            JinqPostgresQuery newQuery = null;
            try {
                newQuery = transform.apply(this.query, null);
            }
            catch (QueryTransformException e) {
                throw new RuntimeException(e);
            }
            finally {
                cachedQuery = Optional.ofNullable(newQuery);
                cachedQuery = this.cachedQueries.cacheQuery(this.query, transform.getTransformationTypeCachingTag(), null, cachedQuery);
            }
        }
        if (!cachedQuery.isPresent()) {
            return null;
        }
        return new RevenjQueryComposer<Object>(this, newManifest, cachedQuery.get(), this.lambdas, new LambdaInfo[0]);
    }

    public <U> RevenjQueryComposer<U> applyTransformWithLambda(Class<U> newManifest, RevenjOneLambdaQueryTransform transform, LambdaInfo lambdaInfo) {
        if (lambdaInfo == null) {
            return null;
        }
        Optional<JinqPostgresQuery<Object>> cachedQuery = this.cachedQueries.findInCache(this.query, transform.getTransformationTypeCachingTag(), new String[]{lambdaInfo.getLambdaSourceString()});
        if (cachedQuery == null) {
            LambdaAnalysis lambdaAnalysis;
            JinqPostgresQuery newQuery;
            block8: {
                newQuery = null;
                lambdaAnalysis = lambdaInfo.fullyAnalyze(this.metamodel, this.loader, true, true, true, true);
                if (lambdaAnalysis != null) break block8;
                RevenjQueryComposer<U> revenjQueryComposer = null;
                cachedQuery = Optional.ofNullable(newQuery);
                cachedQuery = this.cachedQueries.cacheQuery(this.query, transform.getTransformationTypeCachingTag(), new String[]{lambdaInfo.getLambdaSourceString()}, cachedQuery);
                return revenjQueryComposer;
            }
            try {
                this.getConfig().checkLambdaSideEffects(lambdaAnalysis);
                newQuery = transform.apply(this.query, lambdaAnalysis, null);
            }
            catch (QueryTransformException e) {
                try {
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable) {
                    cachedQuery = Optional.ofNullable(newQuery);
                    cachedQuery = this.cachedQueries.cacheQuery(this.query, transform.getTransformationTypeCachingTag(), new String[]{lambdaInfo.getLambdaSourceString()}, cachedQuery);
                    throw throwable;
                }
            }
            cachedQuery = Optional.ofNullable(newQuery);
            cachedQuery = this.cachedQueries.cacheQuery(this.query, transform.getTransformationTypeCachingTag(), new String[]{lambdaInfo.getLambdaSourceString()}, cachedQuery);
        }
        if (!cachedQuery.isPresent()) {
            return null;
        }
        return new RevenjQueryComposer<U>(this, newManifest, cachedQuery.get(), this.lambdas, lambdaInfo);
    }

    public <U> RevenjQueryComposer<U> applyTransformWithLambdas(Class<U> newManifest, RevenjMultiLambdaQueryTransform transform, Object[] groupingLambdas) {
        LambdaInfo[] lambdaInfos = new LambdaInfo[groupingLambdas.length];
        String[] lambdaSources = new String[lambdaInfos.length];
        for (int n = 0; n < groupingLambdas.length; ++n) {
            lambdaInfos[n] = LambdaInfo.analyze(groupingLambdas[n], this.lambdas.size() + n, true);
            if (lambdaInfos[n] == null) {
                return null;
            }
            lambdaSources[n] = lambdaInfos[n].getLambdaSourceString();
        }
        Optional<JinqPostgresQuery<Object>> cachedQuery = this.cachedQueries.findInCache(this.query, transform.getTransformationTypeCachingTag(), lambdaSources);
        if (cachedQuery == null) {
            JinqPostgresQuery newQuery = null;
            try {
                LambdaAnalysis[] lambdaAnalyses = new LambdaAnalysis[lambdaInfos.length];
                for (int n = 0; n < lambdaInfos.length; ++n) {
                    lambdaAnalyses[n] = lambdaInfos[n].fullyAnalyze(this.metamodel, null, true, true, true, true);
                    if (lambdaAnalyses[n] == null) {
                        RevenjQueryComposer<U> revenjQueryComposer = null;
                        return revenjQueryComposer;
                    }
                    this.getConfig().checkLambdaSideEffects(lambdaAnalyses[n]);
                }
                newQuery = transform.apply(this.query, lambdaAnalyses, null);
            }
            catch (QueryTransformException e) {
                throw new RuntimeException(e);
            }
            finally {
                cachedQuery = Optional.ofNullable(newQuery);
                cachedQuery = this.cachedQueries.cacheQuery(this.query, transform.getTransformationTypeCachingTag(), lambdaSources, cachedQuery);
            }
        }
        if (!cachedQuery.isPresent()) {
            return null;
        }
        return new RevenjQueryComposer<U>(this, newManifest, cachedQuery.get(), this.lambdas, lambdaInfos);
    }

    public RevenjQueryTransformConfiguration getConfig() {
        if (this.transformationConfig == null) {
            this.transformationConfig = new RevenjQueryTransformConfiguration();
            this.transformationConfig.metamodel = this.metamodel;
            this.transformationConfig.alternateClassLoader = null;
            this.transformationConfig.isObjectEqualsSafe = true;
            this.transformationConfig.isCollectionContainsSafe = true;
        }
        return this.transformationConfig;
    }

    public Specification rewrite(Specification filter) {
        Function<Specification, Specification> conversion = this.metamodel.lookupRewrite(filter);
        return conversion != null ? conversion.apply(filter) : filter;
    }

    public <E extends Exception> RevenjQueryComposer<T> where(LambdaInfo lambdaInfo) {
        return this.applyTransformWithLambda(this.manifest, new WhereTransform(this.getConfig(), false), lambdaInfo);
    }

    public <V extends Comparable<V>> RevenjQueryComposer<T> sortedBy(LambdaInfo lambdaInfo, boolean isAscending) {
        return this.applyTransformWithLambda(this.manifest, new SortingTransform(this.getConfig(), isAscending), lambdaInfo);
    }

    public RevenjQueryComposer<T> limit(long n) {
        return this.applyTransformWithLambda(this.manifest, new LimitSkipTransform(this.getConfig(), true, n));
    }

    public RevenjQueryComposer<T> skip(long n) {
        return this.applyTransformWithLambda(this.manifest, new LimitSkipTransform(this.getConfig(), false, n));
    }

    static {
        RevenjQueryComposer.addMapping(Integer.TYPE, "int", 23, 4);
        RevenjQueryComposer.addMapping(Integer.class, "int", 23, 4);
        RevenjQueryComposer.addMapping(String.class, "varchar", 1043, 12);
        RevenjQueryComposer.addMapping(Long.TYPE, "bigint", 20, -5);
        RevenjQueryComposer.addMapping(Long.class, "bigint", 20, -5);
        RevenjQueryComposer.addMapping(BigDecimal.class, "numeric", 1700, 2);
        RevenjQueryComposer.addMapping(Float.TYPE, "real", 700, 6);
        RevenjQueryComposer.addMapping(Float.class, "real", 700, 6);
        RevenjQueryComposer.addMapping(Double.TYPE, "float", 701, 8);
        RevenjQueryComposer.addMapping(Double.class, "float", 701, 8);
        RevenjQueryComposer.addMapping(Boolean.TYPE, "bool", 16, 16);
        RevenjQueryComposer.addMapping(Boolean.class, "bool", 16, 16);
        RevenjQueryComposer.addMapping(LocalDate.class, "date", 1082, 91);
        RevenjQueryComposer.addMapping(OffsetDateTime.class, "timestamptz", 1184, 2014);
        RevenjQueryComposer.addMapping(UUID.class, "uuid", 2950, 1111);
        RevenjQueryComposer.addMapping(Map.class, "hstore", -1, 1111);
        RevenjQueryComposer.addMapping(byte[].class, "bytea", 17, 2004);
        EMPTY_ARRAY = new PGobject();
        EMPTY_ARRAY.setType("record[]");
        try {
            EMPTY_ARRAY.setValue("{}");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        objectConverters = new ConcurrentHashMap();
    }

    @FunctionalInterface
    public static interface ReleaseConnection {
        public void release(Connection var1) throws SQLException;
    }

    @FunctionalInterface
    public static interface GetConnection {
        public Connection get() throws SQLException;
    }
}

