/*
 * Decompiled with CFR 0.152.
 */
package org.revenj.database.postgres.jinq.jpqlquery;

import org.revenj.database.postgres.jinq.jpqlquery.Expression;
import org.revenj.database.postgres.jinq.jpqlquery.ExpressionVisitor;
import org.revenj.database.postgres.jinq.jpqlquery.OperatorPrecedenceLevel;
import org.revenj.database.postgres.jinq.jpqlquery.QueryGenerationState;

public class AggregateFunctionExpression
extends Expression {
    final Expression base;
    final String aggregateName;
    final boolean isDistinct;

    public AggregateFunctionExpression(Expression base, String aggregateName, boolean isDistinct) {
        this.base = base;
        this.aggregateName = aggregateName;
        this.isDistinct = isDistinct;
    }

    @Override
    public void generateQuery(QueryGenerationState queryState, OperatorPrecedenceLevel operatorPrecedenceScope) {
        queryState.appendQuery(this.aggregateName);
        queryState.appendQuery("(");
        if (this.isDistinct) {
            queryState.appendQuery("DISTINCT ");
        }
        this.base.generateQuery(queryState, OperatorPrecedenceLevel.JPQL_UNRESTRICTED_OPERATOR_PRECEDENCE);
        queryState.appendQuery(")");
    }

    @Override
    public void prepareQueryGeneration(Expression.QueryGenerationPreparationPhase preparePhase, QueryGenerationState queryState) {
        this.base.prepareQueryGeneration(preparePhase, queryState);
    }

    @Override
    public boolean equals(Object obj) {
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        AggregateFunctionExpression o = (AggregateFunctionExpression)obj;
        return this.base.equals(o.base) && this.aggregateName.equals(o.aggregateName) && this.isDistinct == o.isDistinct;
    }

    @Override
    public void visit(ExpressionVisitor visitor) {
        visitor.visitAggregateFunction(this);
    }
}

