/*
 * Decompiled with CFR 0.152.
 */
package org.revenj.database.postgres.jinq.jpqlquery;

import java.util.List;
import org.revenj.database.postgres.jinq.jpqlquery.Expression;
import org.revenj.database.postgres.jinq.jpqlquery.ExpressionVisitor;
import org.revenj.database.postgres.jinq.jpqlquery.OperatorPrecedenceLevel;
import org.revenj.database.postgres.jinq.jpqlquery.QueryGenerationState;

public class CaseWhenExpression
extends Expression {
    final List<ConditionResult> cases;

    public CaseWhenExpression(List<ConditionResult> cases) {
        this.cases = cases;
    }

    @Override
    public void generateQuery(QueryGenerationState queryState, OperatorPrecedenceLevel operatorPrecedenceScope) {
        queryState.appendQuery("CASE");
        for (int n = 0; n < this.cases.size() - 1; ++n) {
            queryState.appendQuery(" WHEN ");
            this.cases.get((int)n).condition.generateQuery(queryState, OperatorPrecedenceLevel.JPQL_UNRESTRICTED_OPERATOR_PRECEDENCE);
            queryState.appendQuery(" THEN ");
            this.cases.get((int)n).result.generateQuery(queryState, OperatorPrecedenceLevel.JPQL_UNRESTRICTED_OPERATOR_PRECEDENCE);
        }
        queryState.appendQuery(" ELSE ");
        this.cases.get((int)(this.cases.size() - 1)).result.generateQuery(queryState, OperatorPrecedenceLevel.JPQL_UNRESTRICTED_OPERATOR_PRECEDENCE);
        queryState.appendQuery(" END");
    }

    @Override
    public void prepareQueryGeneration(Expression.QueryGenerationPreparationPhase preparePhase, QueryGenerationState queryState) {
        for (ConditionResult c : this.cases) {
            c.condition.prepareQueryGeneration(preparePhase, queryState);
            c.result.prepareQueryGeneration(preparePhase, queryState);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        CaseWhenExpression o = (CaseWhenExpression)obj;
        if (this.cases.size() != o.cases.size()) {
            return false;
        }
        for (int n = 0; n < this.cases.size(); ++n) {
            if (this.cases.get((int)n).condition.equals(o.cases.get((int)n).condition) && this.cases.get((int)n).result.equals(o.cases.get((int)n).result)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void visit(ExpressionVisitor visitor) {
        visitor.visitCaseWhen(this);
    }

    public static class ConditionResult {
        public Expression condition;
        public Expression result;
    }
}

