/*
 * Decompiled with CFR 0.152.
 */
package org.revenj.database.postgres.jinq.jpqlquery;

import java.util.ArrayList;
import java.util.List;
import org.revenj.database.postgres.jinq.jpqlquery.Expression;
import org.revenj.database.postgres.jinq.jpqlquery.RowReader;

public class ColumnExpressions<T> {
    public List<Expression> columns = new ArrayList<Expression>();
    public RowReader<T> reader;

    public ColumnExpressions(RowReader<T> reader) {
        this.reader = reader;
    }

    public static <U> ColumnExpressions<U> singleColumn(RowReader<U> reader, Expression expr) {
        ColumnExpressions<U> columnExpressions = new ColumnExpressions<U>(reader);
        columnExpressions.columns.add(expr);
        return columnExpressions;
    }

    public boolean isSingleColumn() {
        return this.getNumColumns() == 1;
    }

    public int getNumColumns() {
        return this.columns.size();
    }

    public Expression getOnlyColumn() {
        if (!this.isSingleColumn()) {
            throw new IllegalArgumentException("Expecting a single column");
        }
        return this.columns.get(0);
    }
}

