/*
 * Decompiled with CFR 0.152.
 */
package org.revenj.database.postgres.jinq.jpqlquery;

import java.util.List;
import java.util.function.Function;
import org.revenj.database.postgres.jinq.jpqlquery.Expression;
import org.revenj.database.postgres.jinq.jpqlquery.ExpressionVisitor;
import org.revenj.database.postgres.jinq.jpqlquery.GeneratedQueryParameter;
import org.revenj.database.postgres.jinq.jpqlquery.GetterExpression;
import org.revenj.database.postgres.jinq.jpqlquery.OperatorPrecedenceLevel;
import org.revenj.database.postgres.jinq.jpqlquery.QueryGenerationState;
import org.revenj.database.postgres.jinq.transform.LambdaInfo;

public class SqlPredicateExpression
extends Expression {
    final String function;
    final int lambdaIndex;
    final List<GetterExpression> parameters;

    public SqlPredicateExpression(String function, int lambdaIndex, List<GetterExpression> parameters) {
        this.function = function;
        this.lambdaIndex = lambdaIndex;
        this.parameters = parameters;
    }

    @Override
    public void generateQuery(QueryGenerationState queryState, OperatorPrecedenceLevel operatorPrecedenceScope) {
        queryState.appendQuery(this.function);
        queryState.appendQuery("(");
        queryState.appendQuery(queryState.fromAliases.values().iterator().next());
        for (GetterExpression pf : this.parameters) {
            queryState.appendQuery(",?");
            Function<LambdaInfo, Object> getValue = li -> pf.getter.apply(li.getCapturedArg(0));
            queryState.parameters.add(new GeneratedQueryParameter(null, this.lambdaIndex, getValue, pf.javaType, pf.sqlType));
        }
        queryState.appendQuery(")");
    }

    @Override
    public void prepareQueryGeneration(Expression.QueryGenerationPreparationPhase preparePhase, QueryGenerationState queryState) {
    }

    @Override
    public boolean equals(Object obj) {
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        SqlPredicateExpression o = (SqlPredicateExpression)obj;
        return this.function.equals(o.function) && this.parameters.size() == o.parameters.size();
    }

    @Override
    public void visit(ExpressionVisitor visitor) {
        visitor.visitDefaultExpression(this);
    }
}

