/*
 * Decompiled with CFR 0.152.
 */
package org.revenj.database.postgres.jinq.transform;

import ch.epfl.labos.iu.orm.queryll2.symbolic.TypedValueVisitorException;
import org.revenj.database.postgres.jinq.jpqlquery.ColumnExpressions;
import org.revenj.database.postgres.jinq.jpqlquery.JinqPostgresQuery;
import org.revenj.database.postgres.jinq.jpqlquery.RowReader;
import org.revenj.database.postgres.jinq.jpqlquery.SelectFromWhere;
import org.revenj.database.postgres.jinq.jpqlquery.SelectOnly;
import org.revenj.database.postgres.jinq.jpqlquery.TupleRowReader;
import org.revenj.database.postgres.jinq.transform.AggregateStreamLambdaArgumentHandler;
import org.revenj.database.postgres.jinq.transform.LambdaAnalysis;
import org.revenj.database.postgres.jinq.transform.QueryTransformException;
import org.revenj.database.postgres.jinq.transform.RevenjMultiLambdaQueryTransform;
import org.revenj.database.postgres.jinq.transform.RevenjQueryTransformConfiguration;
import org.revenj.database.postgres.jinq.transform.SymbExArgumentHandler;
import org.revenj.database.postgres.jinq.transform.SymbExToColumns;

public class MultiAggregateTransform
extends RevenjMultiLambdaQueryTransform {
    public MultiAggregateTransform(RevenjQueryTransformConfiguration config) {
        super(config);
    }

    @Override
    public <U, V> JinqPostgresQuery<U> apply(JinqPostgresQuery<V> query, LambdaAnalysis[] lambdas, SymbExArgumentHandler parentArgumentScope) throws QueryTransformException {
        try {
            if (query.isSelectFromWhere()) {
                SelectFromWhere sfw = (SelectFromWhere)query;
                SelectOnly streamTee = new SelectOnly();
                streamTee.cols = sfw.cols;
                ColumnExpressions[] aggregatedQueryEntries = new ColumnExpressions[lambdas.length];
                for (int n = 0; n < lambdas.length; ++n) {
                    ColumnExpressions returnQuery;
                    LambdaAnalysis lambda = lambdas[n];
                    AggregateStreamLambdaArgumentHandler argHandler = new AggregateStreamLambdaArgumentHandler(streamTee, lambda, this.config.metamodel, parentArgumentScope, false);
                    SymbExToColumns translator = this.config.newSymbExToColumns(argHandler, n);
                    aggregatedQueryEntries[n] = returnQuery = this.makeSelectExpression(translator, lambda);
                }
                SelectOnly toReturn = sfw.shallowCopy();
                ((SelectFromWhere)toReturn).isAggregated = true;
                RowReader[] readers = new RowReader[aggregatedQueryEntries.length];
                for (int n = 0; n < readers.length; ++n) {
                    readers[n] = aggregatedQueryEntries[n].reader;
                }
                ColumnExpressions<U> cols = new ColumnExpressions<U>(this.createTupleReader(readers));
                for (int n = 0; n < readers.length; ++n) {
                    cols.columns.addAll(aggregatedQueryEntries[n].columns);
                }
                ((SelectFromWhere)toReturn).cols = cols;
                return toReturn;
            }
            throw new QueryTransformException("Existing query cannot be transformed further");
        }
        catch (TypedValueVisitorException e) {
            throw new QueryTransformException(e);
        }
    }

    protected <U> RowReader<U> createTupleReader(RowReader<?>[] readers) {
        return TupleRowReader.createReaderForTuple(readers);
    }

    @Override
    public String getTransformationTypeCachingTag() {
        return MultiAggregateTransform.class.getName();
    }
}

