/*
 * Decompiled with CFR 0.152.
 */
package org.revenj.database.postgres.jinq.transform;

import ch.epfl.labos.iu.orm.queryll2.path.PathAnalysis;
import ch.epfl.labos.iu.orm.queryll2.path.PathAnalysisSimplifier;
import ch.epfl.labos.iu.orm.queryll2.symbolic.ConstantValue;
import ch.epfl.labos.iu.orm.queryll2.symbolic.TypedValue;
import ch.epfl.labos.iu.orm.queryll2.symbolic.TypedValueVisitor;
import ch.epfl.labos.iu.orm.queryll2.symbolic.TypedValueVisitorException;
import java.util.List;
import org.revenj.database.postgres.jinq.jpqlquery.BinaryExpression;
import org.revenj.database.postgres.jinq.jpqlquery.ColumnExpressions;
import org.revenj.database.postgres.jinq.jpqlquery.Expression;
import org.revenj.database.postgres.jinq.jpqlquery.GroupedSelectFromWhere;
import org.revenj.database.postgres.jinq.jpqlquery.JinqPostgresQuery;
import org.revenj.database.postgres.jinq.jpqlquery.SelectFromWhere;
import org.revenj.database.postgres.jinq.jpqlquery.SelectOnly;
import org.revenj.database.postgres.jinq.transform.LambdaAnalysis;
import org.revenj.database.postgres.jinq.transform.QueryTransformException;
import org.revenj.database.postgres.jinq.transform.RevenjOneLambdaQueryTransform;
import org.revenj.database.postgres.jinq.transform.RevenjQueryTransformConfiguration;
import org.revenj.database.postgres.jinq.transform.SelectFromWhereLambdaArgumentHandler;
import org.revenj.database.postgres.jinq.transform.SymbExArgumentHandler;
import org.revenj.database.postgres.jinq.transform.SymbExPassDown;
import org.revenj.database.postgres.jinq.transform.SymbExToColumns;

public class WhereTransform
extends RevenjOneLambdaQueryTransform {
    boolean withSource;

    public WhereTransform(RevenjQueryTransformConfiguration config, boolean withSource) {
        super(config);
        this.withSource = withSource;
    }

    @Override
    public <U, V> JinqPostgresQuery<U> apply(JinqPostgresQuery<V> query, LambdaAnalysis where, SymbExArgumentHandler parentArgumentScope) throws QueryTransformException {
        try {
            if (query.isSelectFromWhere()) {
                SelectFromWhere sfw = (SelectFromWhere)query;
                return this.apply(where, parentArgumentScope, sfw);
            }
            if (query.isSelectFromWhereGroupHaving()) {
                GroupedSelectFromWhere sfw = (GroupedSelectFromWhere)query;
                Expression methodExpr = this.computeWhereReturnExpr(where, sfw, parentArgumentScope);
                SelectFromWhere toReturn = sfw.shallowCopy();
                ((GroupedSelectFromWhere)toReturn).having = sfw.having == null ? methodExpr : new BinaryExpression(sfw.having, "AND", methodExpr);
                return toReturn;
            }
            throw new QueryTransformException("Existing query cannot be transformed further");
        }
        catch (TypedValueVisitorException e) {
            throw new QueryTransformException(e);
        }
    }

    public <T> SelectFromWhere<T> apply(LambdaAnalysis where, SymbExArgumentHandler parentArgumentScope, SelectFromWhere<T> sfw) throws TypedValueVisitorException, QueryTransformException {
        Expression methodExpr = this.computeWhereReturnExpr(where, sfw, parentArgumentScope);
        SelectOnly toReturn = sfw.shallowCopy();
        ((SelectFromWhere)toReturn).where = sfw.where == null ? methodExpr : new BinaryExpression(sfw.where, "AND", methodExpr);
        return toReturn;
    }

    private <V> Expression computeWhereReturnExpr(LambdaAnalysis where, SelectFromWhere<V> sfw, SymbExArgumentHandler parentArgumentScope) throws TypedValueVisitorException, QueryTransformException {
        SelectFromWhereLambdaArgumentHandler argHandler = SelectFromWhereLambdaArgumentHandler.fromSelectFromWhere(sfw, where, this.config.metamodel, parentArgumentScope, this.withSource);
        SymbExToColumns translator = this.config.newSymbExToColumns(argHandler, where.getLambdaIndex());
        Expression methodExpr = null;
        List paths = where.symbolicAnalysis.paths;
        for (int n = 0; n < paths.size(); ++n) {
            SymbExPassDown returnPassdown;
            PathAnalysis path = (PathAnalysis)paths.get(n);
            TypedValue returnVal = PathAnalysisSimplifier.simplifyBoolean((TypedValue)path.getReturnValue(), this.config.getComparisonMethods(), this.config.getStaticComparisonMethods(), (boolean)this.config.isAllEqualsSafe);
            ColumnExpressions returnColumns = (ColumnExpressions)returnVal.visit((TypedValueVisitor)translator, (Object)(returnPassdown = SymbExPassDown.with(null, true)));
            if (!returnColumns.isSingleColumn()) {
                throw new QueryTransformException("Expecting single column");
            }
            Expression returnExpr = returnColumns.getOnlyColumn();
            if (returnVal instanceof ConstantValue.BooleanConstant) {
                if (((ConstantValue.BooleanConstant)returnVal).val) {
                    returnExpr = null;
                } else if (paths.size() > 1) continue;
            }
            Expression conditionExpr = this.pathConditionsToExpr(translator, path);
            Expression pathExpr = returnExpr;
            if (conditionExpr != null) {
                pathExpr = pathExpr == null ? conditionExpr : new BinaryExpression(pathExpr, "AND", conditionExpr);
            }
            methodExpr = methodExpr != null ? new BinaryExpression(methodExpr, "OR", pathExpr) : pathExpr;
        }
        return methodExpr;
    }

    @Override
    public String getTransformationTypeCachingTag() {
        return WhereTransform.class.getName();
    }
}

