/*
 * Decompiled with CFR 0.152.
 */
package org.revenj.patterns;

import java.util.List;
import java.util.concurrent.Callable;
import rx.Observable;

public interface DataChangeNotification {
    public Observable<NotifyInfo> getNotifications();

    public <T> Observable<TrackInfo<T>> track(Class<T> var1);

    public static final class TrackInfo<T> {
        public final String[] uris;
        public final Callable<List<T>> result;

        public TrackInfo(String[] uris, Callable<List<T>> result) {
            this.uris = uris;
            this.result = result;
        }
    }

    public static enum Source {
        Database,
        Local;

    }

    public static enum Operation {
        Insert,
        Update,
        Change,
        Delete;

    }

    public static final class NotifyInfo {
        public final String name;
        public final Operation operation;
        public final Source source;
        public final String[] uris;

        public NotifyInfo(String name, Operation operation, Source source, String[] uris) {
            this.name = name;
            this.operation = operation;
            this.source = source;
            this.uris = uris;
        }
    }
}

