/*
 * Decompiled with CFR 0.152.
 */
package org.revenj.serialization.json;

import com.dslplatform.json.JsonReader;
import com.dslplatform.json.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.revenj.TreePath;

public abstract class TreePathConverter {
    static final JsonReader.ReadObject<TreePath> Reader = TreePathConverter::deserialize;
    static final JsonWriter.WriteObject<TreePath> Writer = (writer, value) -> TreePathConverter.serializeNullable(value, writer);

    public static void serializeNullable(TreePath value, JsonWriter sw) {
        if (value == null) {
            sw.writeNull();
        } else {
            TreePathConverter.serialize(value, sw);
        }
    }

    public static void serialize(TreePath value, JsonWriter sw) {
        sw.writeByte((byte)34);
        sw.writeAscii(value.toString());
        sw.writeByte((byte)34);
    }

    public static TreePath deserialize(JsonReader reader) throws IOException {
        char[] tmp = reader.readSimpleQuote();
        int len = reader.getCurrentIndex() - reader.getTokenStart() - 1;
        if (len == 0) {
            return TreePath.EMPTY;
        }
        return TreePath.create(new String(tmp, 0, len));
    }

    public static ArrayList<TreePath> deserializeCollection(JsonReader reader) throws IOException {
        return reader.deserializeCollection(Reader);
    }

    public static void deserializeCollection(JsonReader reader, Collection<TreePath> res) throws IOException {
        reader.deserializeCollection(Reader, res);
    }

    public static ArrayList<TreePath> deserializeNullableCollection(JsonReader reader) throws IOException {
        return reader.deserializeNullableCollection(Reader);
    }

    public static void deserializeNullableCollection(JsonReader reader, Collection<TreePath> res) throws IOException {
        reader.deserializeNullableCollection(Reader, res);
    }
}

