/*
 * Decompiled with CFR 0.152.
 */
package org.revenj.serialization.xml;

import java.awt.Point;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.net.URL;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMResult;
import org.revenj.TreePath;
import org.revenj.Utils;
import org.revenj.extensibility.Container;
import org.revenj.extensibility.PluginLoader;
import org.revenj.serialization.Serialization;
import org.revenj.serialization.xml.BoolXML;
import org.revenj.serialization.xml.DateXML;
import org.revenj.serialization.xml.DecimalXML;
import org.revenj.serialization.xml.DoubleXML;
import org.revenj.serialization.xml.FloatXML;
import org.revenj.serialization.xml.IntegerXML;
import org.revenj.serialization.xml.JaxbConfiguration;
import org.revenj.serialization.xml.LongXML;
import org.revenj.serialization.xml.PointDoubleXML;
import org.revenj.serialization.xml.PointIntXML;
import org.revenj.serialization.xml.StringXML;
import org.revenj.serialization.xml.TimestampXML;
import org.revenj.serialization.xml.TreePathXML;
import org.revenj.serialization.xml.UrlXML;
import org.revenj.serialization.xml.UuidXML;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XmlJaxbSerialization
implements Serialization<Element> {
    private final Map<Type, Map.Entry<Marshaller, Unmarshaller>> converters = new HashMap<Type, Map.Entry<Marshaller, Unmarshaller>>();
    private final Map<Type, Function> packers = new HashMap<Type, Function>();
    private final Map<Type, Function> unpackers = new HashMap<Type, Function>();
    private static final ThreadLocal<DocumentBuilder> documentBuilder = new ThreadLocal<DocumentBuilder>(){

        @Override
        public DocumentBuilder initialValue() {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            try {
                return dbFactory.newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                throw new RuntimeException(e);
            }
        }
    };
    private static final byte[] NULL = "<object nil=\"true\"/>".getBytes();
    private static final byte[] EMPTY = "<ArrayOfobject/>".getBytes();

    public XmlJaxbSerialization(Container container, Optional<PluginLoader> extensibility) throws IOException {
        this(extensibility.isPresent() ? XmlJaxbSerialization.getPlugins(container, extensibility.get()) : new JaxbConfiguration[]{});
    }

    private static JaxbConfiguration[] getPlugins(Container container, PluginLoader loader) throws IOException {
        try {
            return loader.resolve(container, JaxbConfiguration.class);
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
    }

    public XmlJaxbSerialization(JaxbConfiguration[] plugins) {
        this.register(String.class, StringXML.class, StringXML.convert, s -> s.value);
        this.registerArray(String.class, StringXML.ArrayXML.class, StringXML.ArrayXML.convert, s -> s.value);
        this.registerList(String.class, StringXML.ListXML.class, StringXML.ListXML.convert, s -> s.value);
        this.register(Integer.class, IntegerXML.class, IntegerXML.convert, s -> s.value);
        this.register(Integer.TYPE, IntegerXML.class, IntegerXML.convert, s -> s.value);
        this.registerArray(Integer.class, IntegerXML.ObjectArray.class, IntegerXML.ObjectArray.convert, s -> s.value);
        this.registerList(Integer.class, IntegerXML.ListXML.class, IntegerXML.ListXML.convert, s -> s.value);
        this.register(int[].class, IntegerXML.PrimitiveArray.class, IntegerXML.PrimitiveArray.convert, s -> s.value);
        this.register(Long.class, LongXML.class, LongXML.convert, s -> s.value);
        this.register(Long.TYPE, LongXML.class, LongXML.convert, s -> s.value);
        this.registerArray(Long.class, LongXML.ObjectArray.class, LongXML.ObjectArray.convert, s -> s.value);
        this.registerList(Long.class, LongXML.ListXML.class, LongXML.ListXML.convert, s -> s.value);
        this.register(long[].class, LongXML.PrimitiveArray.class, LongXML.PrimitiveArray.convert, s -> s.value);
        this.register(Float.class, FloatXML.class, FloatXML.convert, s -> s.value);
        this.register(Float.TYPE, FloatXML.class, FloatXML.convert, s -> s.value);
        this.registerArray(Float.class, FloatXML.ObjectArray.class, FloatXML.ObjectArray.convert, s -> s.value);
        this.registerList(Float.class, FloatXML.ListXML.class, FloatXML.ListXML.convert, s -> s.value);
        this.register(float[].class, FloatXML.PrimitiveArray.class, FloatXML.PrimitiveArray.convert, s -> s.value);
        this.register(Double.class, DoubleXML.class, DoubleXML.convert, s -> s.value);
        this.register(Double.TYPE, DoubleXML.class, DoubleXML.convert, s -> s.value);
        this.registerArray(Double.class, DoubleXML.ObjectArray.class, DoubleXML.ObjectArray.convert, s -> s.value);
        this.registerList(Double.class, DoubleXML.ListXML.class, DoubleXML.ListXML.convert, s -> s.value);
        this.register(double[].class, DoubleXML.PrimitiveArray.class, DoubleXML.PrimitiveArray.convert, s -> s.value);
        this.register(Boolean.class, BoolXML.class, BoolXML.convert, s -> s.value);
        this.register(Boolean.TYPE, BoolXML.class, BoolXML.convert, s -> s.value);
        this.registerArray(Boolean.class, BoolXML.ObjectArray.class, BoolXML.ObjectArray.convert, s -> s.value);
        this.registerList(Boolean.class, BoolXML.ListXML.class, BoolXML.ListXML.convert, s -> s.value);
        this.register(boolean[].class, BoolXML.PrimitiveArray.class, BoolXML.PrimitiveArray.convert, s -> s.value);
        this.register(BigDecimal.class, DecimalXML.class, DecimalXML.convert, s -> s.value);
        this.registerArray(BigDecimal.class, DecimalXML.ArrayXML.class, DecimalXML.ArrayXML.convert, s -> s.value);
        this.registerList(BigDecimal.class, DecimalXML.ListXML.class, DecimalXML.ListXML.convert, s -> s.value);
        this.register(LocalDate.class, DateXML.class, DateXML.convert, s -> LocalDate.parse(s.value));
        this.registerArray(LocalDate.class, DateXML.ArrayXML.class, DateXML.ArrayXML.convert, DateXML.ArrayXML.parse);
        this.registerList(LocalDate.class, DateXML.ListXML.class, DateXML.ListXML.convert, DateXML.ListXML.parse);
        this.register(OffsetDateTime.class, TimestampXML.class, TimestampXML.convert, s -> OffsetDateTime.parse(s.value));
        this.registerArray(OffsetDateTime.class, TimestampXML.ArrayXML.class, TimestampXML.ArrayXML.convert, TimestampXML.ArrayXML.parse);
        this.registerList(OffsetDateTime.class, TimestampXML.ListXML.class, TimestampXML.ListXML.convert, TimestampXML.ListXML.parse);
        this.register(UUID.class, UuidXML.class, UuidXML.convert, s -> s.value);
        this.registerArray(UUID.class, UuidXML.ArrayXML.class, UuidXML.ArrayXML.convert, s -> s.value);
        this.registerList(UUID.class, UuidXML.ListXML.class, UuidXML.ListXML.convert, s -> s.value);
        this.register(TreePath.class, TreePathXML.class, TreePathXML.convert, s -> TreePath.create(s.value));
        this.registerArray(TreePath.class, TreePathXML.ArrayXML.class, TreePathXML.ArrayXML.convert, TreePathXML.ArrayXML.parse);
        this.registerList(TreePath.class, TreePathXML.ListXML.class, TreePathXML.ListXML.convert, TreePathXML.ListXML.parse);
        this.register(Point2D.class, PointDoubleXML.class, PointDoubleXML.convert, s -> new Point2D.Double(s.x, s.y));
        this.registerArray(Point2D.class, PointDoubleXML.ArrayXML.class, PointDoubleXML.ArrayXML.convert, PointDoubleXML.ArrayXML.parse);
        this.registerList(Point2D.class, PointDoubleXML.ListXML.class, PointDoubleXML.ListXML.convert, PointDoubleXML.ListXML.parse);
        this.register(Point.class, PointIntXML.class, PointIntXML.convert, s -> new Point(s.x, s.y));
        this.registerArray(Point.class, PointIntXML.ArrayXML.class, PointIntXML.ArrayXML.convert, s -> s.value);
        this.registerList(Point.class, PointIntXML.ListXML.class, PointIntXML.ListXML.convert, s -> s.value);
        this.register(URL.class, UrlXML.class, UrlXML.convert, s -> s.value);
        this.registerArray(URL.class, UrlXML.ArrayXML.class, UrlXML.ArrayXML.convert, s -> s.value);
        this.registerList(URL.class, UrlXML.ListXML.class, UrlXML.ListXML.convert, s -> s.value);
        if (plugins != null) {
            for (JaxbConfiguration it : plugins) {
                it.register(this);
            }
        }
    }

    static Map.Entry<Marshaller, Unmarshaller> create(Class<?> manifest) {
        try {
            JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{manifest});
            Marshaller marshaller = ctx.createMarshaller();
            marshaller.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
            Unmarshaller unmarshaller = ctx.createUnmarshaller();
            return new AbstractMap.SimpleEntry<Marshaller, Unmarshaller>(marshaller, unmarshaller);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    public <T> void register(Class<T> type) {
        this.converters.put(type, XmlJaxbSerialization.create(type));
    }

    public <T> void register(Class<T> container, Type type) {
        this.converters.put(Utils.makeGenericType(container, type, new Type[0]), XmlJaxbSerialization.create(container));
    }

    public <T, W> void register(Class<? extends T> type, Class<W> wrapper, Function<T, W> packer, Function<W, T> unpacker) {
        this.converters.put(type, XmlJaxbSerialization.create(wrapper));
        this.packers.put(type, packer);
        this.unpackers.put(type, unpacker);
    }

    public <T, W> void registerArray(Class<? extends T> content, Class<W> wrapper, Function<T[], W> packer, Function<W, T[]> unpacker) {
        Class<?> type = Array.newInstance(content, 0).getClass();
        this.converters.put(type, XmlJaxbSerialization.create(wrapper));
        this.packers.put(type, packer);
        this.unpackers.put(type, unpacker);
    }

    public <T, W> void registerList(Class<? extends T> content, Class<W> wrapper, Function<List<T>, W> packer, Function<W, List<T>> unpacker) {
        ParameterizedType type = Utils.makeGenericType(List.class, content, new Type[0]);
        this.converters.put(type, XmlJaxbSerialization.create(wrapper));
        this.packers.put(type, packer);
        this.unpackers.put(type, unpacker);
    }

    public void serializeTo(Object value, OutputStream stream) throws IOException {
        if (value == null) {
            stream.write(NULL);
            return;
        }
        Type manifest = this.findBestManifest(value);
        Map.Entry<Marshaller, Unmarshaller> converter = this.converters.get(manifest);
        if (converter == null) {
            if (value instanceof Collection) {
                Collection items = (Collection)value;
                if (items.size() == 0) {
                    stream.write(EMPTY);
                    return;
                }
                ArrayList list = new ArrayList(items.size());
                list.addAll(items);
                manifest = this.findBestManifest(list);
                converter = this.converters.get(manifest);
            }
            if (converter == null) {
                throw new IOException("Unable to find XML marshaller for: " + manifest);
            }
        }
        Function wrapper = this.packers.get(manifest);
        try {
            converter.getKey().marshal(wrapper != null ? wrapper.apply(value) : value, stream);
        }
        catch (JAXBException e) {
            throw new IOException(e);
        }
    }

    private Type findBestManifest(Object value) {
        List items;
        Class<?> container = value.getClass();
        if (List.class.isAssignableFrom(container) && (items = (List)value).size() > 0) {
            for (int i = 0; i < items.size(); ++i) {
                Object item = items.get(i);
                if (item == null) continue;
                return Utils.makeGenericType(List.class, item.getClass(), new Type[0]);
            }
        }
        return container;
    }

    @Override
    public Element serialize(Type manifest, Object value) throws IOException {
        if (manifest == null && value != null) {
            manifest = this.findBestManifest(value);
        }
        if (manifest == null && value == null) {
            Document doc = documentBuilder.get().newDocument();
            Element object = doc.createElement("object");
            object.setAttribute("nil", "true");
            doc.appendChild(object);
            return object;
        }
        Map.Entry<Marshaller, Unmarshaller> converter = this.converters.get(manifest);
        if (converter == null) {
            throw new IOException("Unable to find XML marshaller for: " + manifest);
        }
        Function wrapper = this.packers.get(manifest);
        try {
            DOMResult result = new DOMResult();
            converter.getKey().marshal(wrapper != null ? wrapper.apply(value) : value, (Result)result);
            return ((Document)result.getNode()).getDocumentElement();
        }
        catch (JAXBException e) {
            throw new IOException(e);
        }
    }

    @Override
    public Object deserialize(Type type, InputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        Map.Entry<Marshaller, Unmarshaller> converter = this.converters.get(type);
        if (converter == null) {
            throw new IOException("Unable to find XML unmarshaller for: " + type);
        }
        try {
            Object result = converter.getValue().unmarshal(stream);
            Function wrapper = this.unpackers.get(type);
            return wrapper == null ? result : wrapper.apply(result);
        }
        catch (JAXBException e) {
            throw new IOException(e);
        }
    }

    @Override
    public Object deserialize(Type type, Element data) throws IOException {
        if (data == null) {
            return null;
        }
        if (data.getFirstChild() == null) {
            return null;
        }
        Map.Entry<Marshaller, Unmarshaller> converter = this.converters.get(type);
        if (converter == null) {
            throw new IOException("Unable to find XML unmarshaller for: " + type);
        }
        try {
            Object result = converter.getValue().unmarshal((Node)data);
            Function wrapper = this.unpackers.get(type);
            return wrapper == null ? result : wrapper.apply(result);
        }
        catch (JAXBException e) {
            throw new IOException(e);
        }
    }
}

