/*
 * Decompiled with CFR 0.152.
 */
package org.revenj.spring;

import java.io.File;
import java.io.IOException;
import java.util.Optional;
import java.util.Properties;
import javax.sql.DataSource;
import org.revenj.Revenj;
import org.revenj.extensibility.Container;
import org.revenj.patterns.DataChangeNotification;
import org.revenj.patterns.DataContext;
import org.revenj.patterns.ServiceLocator;
import org.revenj.patterns.UnitOfWork;
import org.revenj.postgres.QueryProvider;
import org.revenj.postgres.jinq.transform.MetamodelUtil;
import org.revenj.security.PermissionManager;
import org.revenj.spring.JinqQueryProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;

@Configuration
public class RevenjStartup {
    @Autowired
    private DataSource dataSource;
    @Autowired
    private ApplicationContext context;
    @Autowired
    private Properties properties;

    @Bean
    public ServiceLocator serviceLocator() throws IOException {
        String path = this.properties.getProperty("revenj.pluginsPath");
        File file = path != null ? new File(path) : null;
        Container container = Revenj.setup((DataSource)this.dataSource, (Properties)this.properties, file != null && file.exists() && file.isDirectory() ? Optional.of(file) : Optional.empty(), Optional.of(this.context.getClassLoader()));
        container.registerInstance(DataSource.class, (Object)this.dataSource, false);
        MetamodelUtil metamodel = (MetamodelUtil)container.resolve(MetamodelUtil.class);
        container.registerInstance(QueryProvider.class, (Object)new JinqQueryProvider(metamodel, this.dataSource), false);
        return container;
    }

    @Bean
    public DataContext dataContext(ServiceLocator locator) {
        return (DataContext)locator.resolve(DataContext.class);
    }

    @Bean
    public DataChangeNotification dataChange(ServiceLocator locator) {
        return (DataChangeNotification)locator.resolve(DataChangeNotification.class);
    }

    @Bean
    public PermissionManager permissionManager(ServiceLocator locator) {
        return (PermissionManager)locator.resolve(PermissionManager.class);
    }

    @Bean
    @Scope(value="prototype")
    public UnitOfWork unitOfWork(ServiceLocator locator) {
        return (UnitOfWork)locator.resolve(UnitOfWork.class);
    }
}

