/*
 * Decompiled with CFR 0.152.
 */
package org.revenj.spring;

import com.dslplatform.json.DslJson;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.util.Optional;
import java.util.Properties;
import javax.sql.DataSource;
import org.revenj.Revenj;
import org.revenj.extensibility.Container;
import org.revenj.json.DslJsonSerialization;
import org.revenj.patterns.DataChangeNotification;
import org.revenj.patterns.DataContext;
import org.revenj.patterns.ServiceLocator;
import org.revenj.postgres.QueryProvider;
import org.revenj.postgres.jinq.transform.MetamodelUtil;
import org.revenj.security.PermissionManager;
import org.revenj.spring.JacksonSetup;
import org.revenj.spring.JinqQueryProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter;

@Configuration
public class RevenjStartup {
    @Autowired(required=false)
    private DataSource dataSource;
    @Autowired
    private ApplicationContext context;
    @Autowired
    private Properties properties;
    @Autowired
    private RequestMappingHandlerAdapter handlerAdapter;

    @Bean
    public ServiceLocator serviceLocator() throws IOException {
        File file;
        String path = this.properties.getProperty("revenj.pluginsPath");
        File file2 = file = path != null ? new File(path) : null;
        if (this.dataSource == null) {
            try {
                this.dataSource = Revenj.dataSource((Properties)this.properties);
            }
            catch (Exception e) {
                throw new IOException("Unable to setup Revenj. Unable to autowire Spring DataSource or setup Revenj Datasource. \nEither configure DataSource within Spring or add revenj.jdbcUrl property.", e);
            }
        }
        Container container = Revenj.setup((DataSource)this.dataSource, (Properties)this.properties, file != null && file.exists() && file.isDirectory() ? Optional.of(file) : Optional.empty(), Optional.of(this.context.getClassLoader()));
        container.registerInstance(DataSource.class, (Object)this.dataSource, false);
        RevenjStartup.setup(container);
        return container;
    }

    public static void setup(Container container) throws IOException {
        MetamodelUtil metamodel = (MetamodelUtil)container.resolve(MetamodelUtil.class);
        DataSource dataSource = (DataSource)container.resolve(DataSource.class);
        ClassLoader loader = (ClassLoader)container.resolve(ClassLoader.class);
        container.registerInstance(QueryProvider.class, (Object)new JinqQueryProvider(metamodel, loader, dataSource), false);
    }

    @Bean
    public DataContext dataContext(ServiceLocator locator) {
        return (DataContext)locator.resolve(DataContext.class);
    }

    @Bean
    public DataChangeNotification dataChange(ServiceLocator locator) {
        return (DataChangeNotification)locator.resolve(DataChangeNotification.class);
    }

    @Bean
    public PermissionManager permissionManager(ServiceLocator locator) {
        return (PermissionManager)locator.resolve(PermissionManager.class);
    }

    private static Optional<DslJson.Fallback<ServiceLocator>> buildFallback(final ObjectMapper mapper) {
        if (mapper == null) {
            return Optional.empty();
        }
        return Optional.of(new DslJson.Fallback<ServiceLocator>(){

            public void serialize(Object instance, OutputStream stream) throws IOException {
                mapper.writeValue(stream, instance);
            }

            public Object deserialize(ServiceLocator serviceLocator, Type type, byte[] bytes, int len) throws IOException {
                return mapper.readValue(bytes, 0, len, mapper.getTypeFactory().constructType(type));
            }

            public Object deserialize(ServiceLocator serviceLocator, Type type, InputStream stream) throws IOException {
                return mapper.readValue(stream, mapper.getTypeFactory().constructType(type));
            }
        });
    }

    @Bean
    public DslJsonSerialization dslJsonSerialization(ServiceLocator locator) {
        MappingJackson2HttpMessageConverter converter = JacksonSetup.findJackson(this.handlerAdapter).orElse(null);
        ObjectMapper mapper = converter == null ? null : converter.getObjectMapper();
        return new DslJsonSerialization(locator, RevenjStartup.buildFallback(mapper));
    }
}

