/*
 * Decompiled with CFR 0.152.
 */
package org.revenj.spring;

import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Optional;
import javax.annotation.PostConstruct;
import org.revenj.patterns.ServiceLocator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter;

@Component
public class JacksonSetup {
    @Autowired
    private RequestMappingHandlerAdapter handlerAdapter;
    @Autowired
    private ServiceLocator locator;

    public static Optional<MappingJackson2HttpMessageConverter> findJackson(RequestMappingHandlerAdapter handlerAdapter) {
        for (HttpMessageConverter messageConverter : handlerAdapter.getMessageConverters()) {
            if (!(messageConverter instanceof MappingJackson2HttpMessageConverter)) continue;
            return Optional.of((MappingJackson2HttpMessageConverter)messageConverter);
        }
        return Optional.empty();
    }

    @PostConstruct
    public void init() {
        JacksonSetup.configure(this.handlerAdapter, this.locator);
    }

    public static void configure(RequestMappingHandlerAdapter handlerAdapter, ServiceLocator locator) {
        JacksonSetup.findJackson(handlerAdapter).ifPresent(m -> {
            ObjectMapper mapper = m.getObjectMapper();
            if (mapper == null) {
                mapper = new ObjectMapper();
            }
            mapper.setInjectableValues((InjectableValues)new InjectableValues.Std().addValue("__locator", (Object)locator));
            m.setObjectMapper(mapper);
        });
    }
}

