/*
 * Decompiled with CFR 0.152.
 */
package org.revenj.spring;

import com.dslplatform.json.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Type;
import org.revenj.serialization.json.DslJsonSerialization;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.AbstractGenericHttpMessageConverter;
import org.springframework.http.converter.GenericHttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;

public class DslJsonMessageConverter
extends AbstractGenericHttpMessageConverter<Object>
implements GenericHttpMessageConverter<Object> {
    private final DslJsonSerialization serializer;
    private static final ThreadLocal<JsonWriter> threadWriter = new ThreadLocal<JsonWriter>(){

        @Override
        protected JsonWriter initialValue() {
            return new JsonWriter();
        }
    };
    private static final ThreadLocal<byte[]> threadBuffer = new ThreadLocal<byte[]>(){

        @Override
        protected byte[] initialValue() {
            return new byte[65536];
        }
    };

    public DslJsonMessageConverter(DslJsonSerialization serializer) {
        super(MediaType.APPLICATION_JSON);
        this.serializer = serializer;
    }

    public boolean canRead(Class<?> clazz, MediaType mediaType) {
        return this.serializer.canDeserialize(clazz) && this.canRead(mediaType);
    }

    public boolean canRead(Type type, Class<?> contextClass, MediaType mediaType) {
        return this.serializer.canDeserialize(type) && this.canRead(mediaType);
    }

    public boolean canWrite(Type type, Class<?> clazz, MediaType mediaType) {
        return this.serializer.canSerialize(type) && this.canWrite(mediaType);
    }

    public boolean canWrite(Class<?> clazz, MediaType mediaType) {
        return this.serializer.canSerialize(clazz) && this.canWrite(mediaType);
    }

    protected boolean supports(Class<?> clazz) {
        return this.serializer.canSerialize(clazz);
    }

    protected Object readInternal(Class<?> clazz, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        return this.serializer.deserialize(clazz, inputMessage.getBody(), threadBuffer.get());
    }

    public Object read(Type type, Class<?> contextClass, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        return this.serializer.deserialize(type, inputMessage.getBody(), threadBuffer.get());
    }

    protected void writeInternal(Object instance, Type type, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        JsonWriter writer = threadWriter.get();
        writer.reset();
        this.serializer.serialize(writer, type, instance);
        writer.toStream(outputMessage.getBody());
    }

    protected MediaType getDefaultContentType(Object object) throws IOException {
        return MediaType.APPLICATION_JSON;
    }
}

