/*
 * Decompiled with CFR 0.152.
 */
package org.revenj.database.postgres.converters;

import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.postgresql.util.PGobject;
import org.revenj.database.postgres.PostgresBuffer;
import org.revenj.database.postgres.PostgresReader;
import org.revenj.database.postgres.converters.ArrayTuple;
import org.revenj.database.postgres.converters.HstoreConverter;
import org.revenj.database.postgres.converters.LongConverter;
import org.revenj.database.postgres.converters.PostgresTuple;
import org.revenj.database.postgres.converters.StringConverter;
import org.revenj.database.postgres.converters.ValueTuple;
import org.revenj.storage.S3;

public abstract class S3Converter {
    public static void setParameter(PostgresBuffer sw, PreparedStatement ps, int index, S3 value) throws SQLException {
        if (value == null) {
            ps.setObject(index, null);
        } else {
            PGobject pg = new PGobject();
            pg.setType("s3");
            pg.setValue(S3Converter.toString(value));
            ps.setObject(index, pg);
        }
    }

    public static void serializeURI(PostgresBuffer sw, S3 value) throws IOException {
        if (value == null) {
            return;
        }
        sw.addToBuffer(S3Converter.toString(value));
    }

    private static String toString(S3 value) {
        String map = HstoreConverter.toTuple(value.getMetadata()).buildTuple(false);
        return String.format("(%s,%s,%d,%s,%s,\"%s\")", value.getBucket() == null ? "" : value.getBucket(), value.getKey() == null ? "" : value.getKey(), value.getLength(), value.getName() == null ? "" : "\"" + value.getName().replace("\\", "\\\\").replace("\"", "\\\"") + "\"", value.getMimeType() == null ? "" : "\"" + value.getMimeType().replace("\\", "\\\\").replace("\"", "\\\"") + "\"", map.replace("\\", "\\\\").replace("\"", "\\\""));
    }

    public static S3 parse(PostgresReader reader, int context) throws IOException {
        int cur = reader.read();
        if (cur == 44 || cur == 41) {
            return null;
        }
        S3 s3 = S3Converter.parseS3(reader, context, context == 0 ? 1 : context << 1);
        reader.read();
        return s3;
    }

    private static S3 parseS3(PostgresReader reader, int context, int innerContext) throws IOException {
        for (int i = 0; i < context; ++i) {
            reader.read();
        }
        String bucket = StringConverter.parse((PostgresReader)reader, (int)innerContext, (boolean)false);
        String key = StringConverter.parse((PostgresReader)reader, (int)innerContext, (boolean)false);
        long length = LongConverter.parse((PostgresReader)reader);
        String name = StringConverter.parse((PostgresReader)reader, (int)innerContext, (boolean)true);
        String mimeType = StringConverter.parse((PostgresReader)reader, (int)innerContext, (boolean)true);
        Map metadata = HstoreConverter.parse((PostgresReader)reader, (int)innerContext, (boolean)false);
        for (int i = 0; i < context; ++i) {
            reader.read();
        }
        return new S3(bucket, key, length, name, mimeType, metadata);
    }

    public static List<S3> parseCollection(PostgresReader reader, int context) throws IOException {
        return ArrayTuple.parse((PostgresReader)reader, (int)context, S3Converter::parseS3);
    }

    public static PostgresTuple toTuple(S3 value) {
        if (value == null) {
            return null;
        }
        return ValueTuple.from((String)S3Converter.toString(value));
    }
}

