/*
 * Decompiled with CFR 0.152.
 */
package org.revenj.serialization.json;

import com.dslplatform.json.JsonReader;
import com.dslplatform.json.JsonWriter;
import com.dslplatform.json.MapConverter;
import com.dslplatform.json.NumberConverter;
import com.dslplatform.json.StringConverter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.revenj.patterns.ServiceLocator;
import org.revenj.storage.S3;

public abstract class StorageConverter {
    public static final JsonReader.ReadObject<S3> S3Reader = StorageConverter::deserializeS3;
    public static final JsonWriter.WriteObject<S3> S3Writer = (writer, value) -> {
        if (value == null) {
            writer.writeNull();
        } else {
            StorageConverter.serialize(value, writer);
        }
    };

    public static void serialize(S3 value, JsonWriter sw) {
        sw.writeAscii("{\"Bucket\":");
        StringConverter.serializeNullable((String)value.getBucket(), (JsonWriter)sw);
        sw.writeAscii(",\"Key\":");
        StringConverter.serializeNullable((String)value.getKey(), (JsonWriter)sw);
        sw.writeAscii(",\"Length\":");
        NumberConverter.serialize((long)value.getLength(), (JsonWriter)sw);
        sw.writeAscii(",\"Name\":");
        StringConverter.serializeNullable((String)value.getName(), (JsonWriter)sw);
        sw.writeAscii(",\"MimeType\":");
        StringConverter.serializeNullable((String)value.getMimeType(), (JsonWriter)sw);
        sw.writeAscii(",\"Metadata\":");
        MapConverter.serializeNullable(value.getMetadata(), (JsonWriter)sw);
        sw.writeByte((byte)125);
    }

    public static S3 deserializeS3(JsonReader<ServiceLocator> reader) throws IOException {
        String bucket = null;
        String key = null;
        long length = 0L;
        String name = null;
        String mimeType = null;
        Map metadata = null;
        if (reader.last() != 125) {
            reader.getNextToken();
            String field = reader.readString();
            if (reader.getNextToken() != 58) {
                throw new IOException("Expecting ':' at " + reader.getCurrentIndex());
            }
            reader.getNextToken();
            if ("Bucket".equalsIgnoreCase(field)) {
                bucket = StringConverter.deserializeNullable(reader);
            } else if ("Key".equalsIgnoreCase(field)) {
                key = StringConverter.deserializeNullable(reader);
            } else if ("Length".equalsIgnoreCase(field)) {
                length = NumberConverter.deserializeLong(reader);
            } else if ("Name".equalsIgnoreCase(field)) {
                name = StringConverter.deserializeNullable(reader);
            } else if ("MimeType".equalsIgnoreCase(field)) {
                mimeType = StringConverter.deserializeNullable(reader);
            } else if ("Metadata".equalsIgnoreCase(field)) {
                metadata = MapConverter.deserialize(reader);
            } else {
                reader.skip();
            }
            while (reader.getNextToken() == 44) {
                reader.getNextToken();
                field = reader.readString();
                if (reader.getNextToken() != 58) {
                    throw new IOException("Expecting ':' at" + reader.getCurrentIndex());
                }
                reader.getNextToken();
                if ("Bucket".equalsIgnoreCase(field)) {
                    bucket = StringConverter.deserializeNullable(reader);
                    continue;
                }
                if ("Key".equalsIgnoreCase(field)) {
                    key = StringConverter.deserializeNullable(reader);
                    continue;
                }
                if ("Length".equalsIgnoreCase(field)) {
                    length = NumberConverter.deserializeLong(reader);
                    continue;
                }
                if ("Name".equalsIgnoreCase(field)) {
                    name = StringConverter.deserializeNullable(reader);
                    continue;
                }
                if ("MimeType".equalsIgnoreCase(field)) {
                    mimeType = StringConverter.deserializeNullable(reader);
                    continue;
                }
                if ("Metadata".equalsIgnoreCase(field)) {
                    metadata = MapConverter.deserialize(reader);
                    continue;
                }
                reader.skip();
            }
            if (reader.last() != 125) {
                throw new IOException("Expecting '}' at " + reader.getCurrentIndex());
            }
        }
        return new S3(bucket, key, length, name, mimeType, metadata);
    }

    public static ArrayList<S3> deserializeS3Collection(JsonReader reader) throws IOException {
        return reader.deserializeCollection(S3Reader);
    }

    public static void deserializeS3Collection(JsonReader reader, Collection<S3> res) throws IOException {
        reader.deserializeCollection(S3Reader, res);
    }

    public static ArrayList<S3> deserializeS3NullableCollection(JsonReader reader) throws IOException {
        return reader.deserializeNullableCollection(S3Reader);
    }

    public static void deserializeS3NullableCollection(JsonReader reader, Collection<S3> res) throws IOException {
        reader.deserializeNullableCollection(S3Reader, res);
    }
}

