/*
 * Decompiled with CFR 0.152.
 */
package org.revenj;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.revenj.storage.S3;
import org.revenj.storage.S3Repository;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.s3.model.DeleteObjectRequest;
import software.amazon.awssdk.services.s3.model.DeleteObjectResponse;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;

class AmazonS3Repository
implements S3Repository,
Closeable {
    private final String bucketName;
    private final ExecutorService executorService;
    private final S3Client s3Client;
    private final boolean disposeExecutor;

    public AmazonS3Repository(Properties properties, Optional<ExecutorService> executorService) {
        this.bucketName = properties.getProperty("revenj.s3-bucket-name");
        String s3AccessKey = properties.getProperty("revenj.s3-user");
        String s3SecretKey = properties.getProperty("revenj.s3-secret");
        String s3Region = properties.getProperty("revenj.s3-region");
        this.disposeExecutor = !executorService.isPresent();
        this.executorService = executorService.orElse(Executors.newSingleThreadExecutor());
        if (s3AccessKey == null || s3AccessKey.isEmpty()) {
            throw new RuntimeException("S3 configuration is missing. Please add revenj.s3-user");
        }
        if (s3SecretKey == null || s3SecretKey.isEmpty()) {
            throw new RuntimeException("S3 configuration is missing. Please add revenj.s3-secret");
        }
        S3ClientBuilder builder = (S3ClientBuilder)S3Client.builder().credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)s3AccessKey, (String)s3SecretKey)));
        if (s3Region != null) {
            builder.region(Region.of((String)s3Region));
        }
        this.s3Client = (S3Client)builder.build();
    }

    private String getBucketName(String name) throws IOException {
        String bn;
        String string = bn = name == null || name.isEmpty() ? this.bucketName : name;
        if (bn == null || bn.isEmpty()) {
            throw new IOException("Bucket name not specified for this S3 instance or system wide.\nEither specify revenj.s3-bucket-name in Properties as system wide name or provide a bucket name to this S3 instance");
        }
        return bn;
    }

    @Override
    public Future<InputStream> get(String bucket, String key) {
        return this.executorService.submit(() -> this.s3Client.getObject((GetObjectRequest)GetObjectRequest.builder().bucket(bucket).key(key).build()));
    }

    @Override
    public Future<S3> upload(String bucket, String key, InputStream stream, long length, String name, String mimeType, Map<String, String> metadata) {
        return this.executorService.submit(() -> {
            String bn = this.getBucketName(bucket);
            PutObjectRequest.Builder builder = PutObjectRequest.builder().bucket(bn).key(key).contentLength(Long.valueOf(length));
            if (metadata != null && !metadata.isEmpty()) {
                builder.metadata(metadata);
            }
            if (mimeType != null && !mimeType.isEmpty()) {
                builder.contentType(mimeType);
            }
            this.s3Client.putObject((PutObjectRequest)builder.build(), RequestBody.fromInputStream((InputStream)stream, (long)length));
            return new S3(bn, key, length, name, mimeType, metadata);
        });
    }

    @Override
    public Future<DeleteObjectResponse> delete(String bucket, String key) {
        return this.executorService.submit(() -> {
            DeleteObjectRequest request = (DeleteObjectRequest)DeleteObjectRequest.builder().bucket(bucket).key(key).build();
            return this.s3Client.deleteObject(request);
        });
    }

    @Override
    public void close() throws IOException {
        if (this.disposeExecutor) {
            this.executorService.shutdown();
        }
    }
}

