/*
 * Decompiled with CFR 0.152.
 */
package org.revenj.storage;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import org.revenj.patterns.ServiceLocator;
import org.revenj.storage.S3Repository;

public class S3 {
    private String bucket;
    private String key;
    private long length;
    private String name;
    private String mimeType;
    private final Map<String, String> metadata = new HashMap<String, String>();
    private byte[] cachedContent;

    public S3() {
    }

    public static S3 from(InputStream stream, ServiceLocator locator) throws IOException {
        S3 s3 = new S3();
        s3.upload(S3.streamToByteArray(stream), locator);
        return s3;
    }

    public S3(String bucket, String key) throws IOException {
        if (bucket == null) {
            throw new IllegalArgumentException("bucket cannot be null!");
        }
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null!");
        }
        this.cachedContent = null;
        this.key = key;
        this.bucket = bucket;
    }

    public static S3 from(InputStream stream, long length, ServiceLocator locator) throws IOException {
        S3 s3 = new S3();
        s3.upload(stream, length, locator);
        return s3;
    }

    public static S3 from(byte[] bytes, ServiceLocator locator) throws IOException {
        S3 s3 = new S3();
        s3.upload(bytes, locator);
        return s3;
    }

    public S3(String bucket, String key, long length, String name, String mimeType, Map<String, String> metadata) {
        this.bucket = bucket;
        this.key = key;
        this.length = length;
        this.name = name;
        this.mimeType = mimeType;
        if (metadata != null) {
            this.metadata.putAll(metadata);
        }
    }

    public String getBucket() {
        return this.bucket;
    }

    public String getKey() {
        return this.key;
    }

    public String getURI() {
        return this.bucket + ":" + this.key;
    }

    public long getLength() {
        return this.length;
    }

    public String getName() {
        return this.name;
    }

    public S3 setName(String value) {
        this.name = value;
        return this;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public S3 setMimeType(String value) {
        this.mimeType = value;
        return this;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public int hashCode() {
        return (this.bucket != null ? this.bucket.hashCode() : 0) ^ (this.key != null ? this.key.hashCode() : 0);
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof S3)) {
            return false;
        }
        S3 s3 = (S3)other;
        return Objects.equals(s3.key, this.key) && Objects.equals(s3.bucket, this.bucket);
    }

    public byte[] getContent(ServiceLocator locator) throws IOException {
        if (this.cachedContent != null) {
            this.cachedContent = this.getBytes(locator);
        }
        return this.cachedContent;
    }

    public InputStream getStream(ServiceLocator locator) throws IOException {
        try {
            return ((S3Repository)locator.resolve(S3Repository.class)).get(this.bucket, this.key).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new IOException(e);
        }
    }

    public byte[] getBytes(ServiceLocator locator) throws IOException {
        InputStream stream;
        try {
            stream = ((S3Repository)locator.resolve(S3Repository.class)).get(this.bucket, this.key).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new IOException(e);
        }
        return S3.streamToByteArray(stream);
    }

    public String upload(ByteArrayInputStream stream, ServiceLocator locator) throws IOException {
        return this.upload(S3.streamToByteArray(stream), locator);
    }

    public String upload(InputStream stream, long length, ServiceLocator locator) throws IOException {
        return this.upload(this.bucket, stream, length, locator);
    }

    public String upload(String bucket, InputStream stream, long length, ServiceLocator locator) throws IOException {
        if (stream == null) {
            throw new IllegalArgumentException("Stream can't be null.");
        }
        if (this.key == null || this.key.isEmpty()) {
            this.bucket = bucket;
            this.key = UUID.randomUUID().toString();
        } else if (!this.bucket.equals(bucket)) {
            throw new IllegalArgumentException("Can't change bucket name");
        }
        try {
            ((S3Repository)locator.resolve(S3Repository.class)).upload(bucket, this.key, stream, length, this.name, this.mimeType, this.metadata).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new IOException(e);
        }
        this.length = length;
        this.cachedContent = null;
        return this.key;
    }

    public String upload(byte[] bytes, ServiceLocator locator) throws IOException {
        return this.upload(this.bucket, bytes, locator);
    }

    public String upload(String bucket, byte[] bytes, ServiceLocator locator) throws IOException {
        if (bytes == null) {
            throw new IllegalArgumentException("Stream/bytes can't be null.");
        }
        if (this.key == null || this.key.isEmpty()) {
            this.bucket = bucket;
            this.key = UUID.randomUUID().toString();
        } else if (!this.bucket.equals(bucket)) {
            throw new IllegalArgumentException("Can't change bucket name");
        }
        ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
        try {
            ((S3Repository)locator.resolve(S3Repository.class)).upload(bucket, this.key, stream, bytes.length, this.name, this.mimeType, this.metadata).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new IOException(e);
        }
        this.length = bytes.length;
        this.cachedContent = null;
        return this.key;
    }

    public void delete(ServiceLocator locator) throws IOException {
        if (this.key == null || this.key.isEmpty()) {
            throw new IllegalArgumentException("S3 object is empty.");
        }
        this.cachedContent = null;
        try {
            ((S3Repository)locator.resolve(S3Repository.class)).delete(this.bucket, this.key).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new IOException(e);
        }
        this.length = 0L;
        this.cachedContent = null;
        this.key = null;
    }

    private static byte[] streamToByteArray(InputStream inputStream) throws IOException {
        int read;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        while ((read = inputStream.read(buffer)) != -1) {
            baos.write(buffer, 0, read);
        }
        return baos.toByteArray();
    }
}

