/*
 * Decompiled with CFR 0.152.
 */
package org.reveno.atp.clustering.api;

import java.net.UnknownHostException;
import java.util.Base64;
import java.util.Objects;
import org.reveno.atp.clustering.api.Address;
import org.reveno.atp.clustering.api.IOMode;
import org.reveno.atp.clustering.util.Bits;
import org.reveno.atp.utils.Exceptions;

public class InetAddress
extends Address {
    private int port;
    private String host;

    public int getPort() {
        return this.port;
    }

    public String getHost() {
        return this.host;
    }

    public InetAddress(String inetAddress, String nodeId) {
        this(inetAddress, nodeId, IOMode.ASYNC);
    }

    public InetAddress(String inetAddress, IOMode addressType) {
        this(inetAddress, Base64.getEncoder().encodeToString(Bits.intToBytes((int)Bits.crc32(inetAddress.getBytes()))), addressType);
    }

    public InetAddress(String inetAddress, String nodeId, IOMode addressType) {
        super(inetAddress, addressType, nodeId);
        String[] vals = inetAddress.split(":");
        this.host = vals[0];
        this.port = Integer.parseInt(vals[1]);
        try {
            java.net.InetAddress addr = java.net.InetAddress.getByName(this.host);
            this.host = addr.getHostAddress();
        }
        catch (UnknownHostException e) {
            throw Exceptions.runtime((Throwable)e);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InetAddress that = (InetAddress)o;
        return Objects.equals(this.port, that.port) && Objects.equals(this.host, that.host);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.port, this.host);
    }

    public String toString() {
        return this.host + ":" + this.port;
    }
}

