/*
 * Decompiled with CFR 0.152.
 */
package org.reveno.atp.clustering.core;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.reveno.atp.clustering.api.Cluster;
import org.reveno.atp.clustering.api.ClusterBuffer;
import org.reveno.atp.clustering.api.ClusterEvent;
import org.reveno.atp.clustering.api.ClusterView;
import org.reveno.atp.clustering.api.SyncMode;
import org.reveno.atp.clustering.api.message.Marshaller;
import org.reveno.atp.clustering.core.ClusterFailoverManager;
import org.reveno.atp.clustering.core.RevenoClusterConfiguration;
import org.reveno.atp.clustering.core.api.ClusterExecutor;
import org.reveno.atp.clustering.core.api.ClusterState;
import org.reveno.atp.clustering.core.api.ElectionResult;
import org.reveno.atp.clustering.core.api.MessagesReceiver;
import org.reveno.atp.clustering.core.api.StorageTransferServer;
import org.reveno.atp.clustering.core.components.GroupBarrier;
import org.reveno.atp.clustering.core.components.StorageTransferModelSync;
import org.reveno.atp.clustering.core.messages.ForceElectionProcess;
import org.reveno.atp.clustering.exceptions.FailoverAbortedException;
import org.reveno.atp.commons.NamedThreadFactory;
import org.reveno.atp.core.JournalsManager;
import org.reveno.atp.utils.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FailoverExecutor {
    private static final int NUM_JOBS_TO_QUEUE = 500;
    protected volatile boolean isStopped = false;
    protected volatile ClusterView lastView = ClusterView.EMPTY_VIEW;
    protected Cluster cluster;
    protected ClusterBuffer buffer;
    protected RevenoClusterConfiguration config;
    protected JournalsManager journalsManager;
    protected ClusterFailoverManager failoverManager;
    protected StorageTransferServer storageServer;
    protected Runnable snapshotMaker = () -> {};
    protected Supplier<Long> replayer = () -> 0L;
    protected Supplier<Long> lastTransactionId = () -> 0L;
    protected ClusterExecutor<ElectionResult, Void> leaderElector;
    protected ClusterExecutor<ClusterState, Void> clusterStateCollector;
    protected ClusterExecutor<Boolean, StorageTransferModelSync.TransferContext> modelSynchronizer;
    protected Runnable failoverListener;
    protected Marshaller marshaller;
    protected final ThreadPoolExecutor electorExecutor;
    protected static final Logger LOG = LoggerFactory.getLogger(FailoverExecutor.class);

    public void init() {
        Preconditions.checkNotNull(this.leaderElector, (Object)"LeaderElector must be provided.");
        Preconditions.checkNotNull(this.clusterStateCollector, (Object)"ClusterStateCollector must be provided.");
        Preconditions.checkNotNull(this.modelSynchronizer, (Object)"ModelSynchronizer must be provided.");
        this.cluster.listenEvents(this::onClusterEvent);
        this.cluster.marshallWith(this.marshaller);
        this.cluster.gateway().receive(16299, f -> this.electorExecutor.submit(() -> this.process(true)));
        this.buffer.failoverNotifier(e -> {
            this.cluster.gateway().send(this.lastView.members(), new ForceElectionProcess(), this.cluster.gateway().oob());
            this.electorExecutor.submit(() -> this.process(true));
        });
    }

    public void stop() {
        this.isStopped = true;
        this.electorExecutor.shutdown();
        try {
            this.electorExecutor.awaitTermination(1L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    public void startElectionProcess() {
        this.onClusterEvent(ClusterEvent.MEMBERSHIP_CHANGED);
    }

    public void leaderElector(ClusterExecutor<ElectionResult, Void> leaderElector) {
        this.leaderElector = leaderElector;
        if (leaderElector instanceof MessagesReceiver) {
            this.subscribe((MessagesReceiver)((Object)leaderElector));
        }
    }

    public void clusterStateCollector(ClusterExecutor<ClusterState, Void> clusterStateCollector) {
        this.clusterStateCollector = clusterStateCollector;
        if (clusterStateCollector instanceof MessagesReceiver) {
            this.subscribe((MessagesReceiver)((Object)clusterStateCollector));
        }
    }

    public void modelSynchronizer(ClusterExecutor<Boolean, StorageTransferModelSync.TransferContext> modelSynchronizer) {
        this.modelSynchronizer = modelSynchronizer;
        if (modelSynchronizer instanceof MessagesReceiver) {
            this.subscribe((MessagesReceiver)((Object)modelSynchronizer));
        }
    }

    public void snapshotMaker(Runnable snapshotMaker) {
        this.snapshotMaker = snapshotMaker;
    }

    public void replayer(Supplier<Long> replayer) {
        this.replayer = replayer;
    }

    public void lastTransactionId(Supplier<Long> lastTransactionId) {
        this.lastTransactionId = lastTransactionId;
    }

    public void marshaller(Marshaller marshaller) {
        this.marshaller = marshaller;
    }

    public void failoverListener(Runnable listener) {
        this.failoverListener = listener;
    }

    public void subscribe(MessagesReceiver ... receivers) {
        for (MessagesReceiver receiver : receivers) {
            for (Integer type : receiver.interestedTypes()) {
                if (receiver.filter().isPresent()) {
                    this.cluster.gateway().receive(type, receiver.filter().get(), receiver::onMessage);
                    continue;
                }
                this.cluster.gateway().receive(type, receiver::onMessage);
            }
        }
    }

    public ClusterView lastView() {
        return this.lastView;
    }

    protected void onClusterEvent(ClusterEvent event) {
        if (event == ClusterEvent.MEMBERSHIP_CHANGED) {
            this.buffer.onView(this.cluster.view());
            this.electorExecutor.submit(() -> this.process(false));
        }
    }

    protected void process(boolean force) {
        block9: {
            ClusterView view;
            LOG.info("Cluster merge process started (forced: {})", (Object)force);
            try {
                view = this.cluster.view();
                if (!force && this.lastView.equals(view)) {
                    LOG.info("Cluster is already up-to-date.");
                    this.notifyListener();
                    return;
                }
                if (!this.isQuorum(view)) {
                    LOG.info("Failover process end: not a quorum [members: {}]", view.members());
                    this.notifyListener();
                    return;
                }
            }
            catch (Throwable t) {
                LOG.error("Unexpected process error.", t);
                return;
            }
            try {
                long t1 = System.currentTimeMillis();
                this.blockIfMaster();
                this.waitOnBarrier(view, "start");
                this.buffer.lockIncoming();
                this.waitOnBarrier(view, "lock-buffer");
                this.rollAndFixJournals(view);
                ElectionResult election = this.leadershipElection(view);
                this.waitOnBarrier(view, "election");
                ClusterState state = this.clusterStateCollection(view);
                this.waitOnBarrier(view, "cluster-state");
                this.buffer.unlockIncoming();
                this.waitOnBarrier(view, "unlock-buffer");
                this.unblockMasterOrSynchronizeSlave(view, election, state);
                this.waitOnBarrier(view, "sync", this.config.revenoElectionTimeouts().syncBarrierTimeoutNanos());
                this.blockIfMaster(() -> !this.config.revenoDataSync().waitAllNodesSync());
                this.waitOnBarrier(view, "block-if-master");
                this.replay(state);
                this.waitOnBarrier(view, "replay");
                if (!election.isMaster) {
                    this.unblock();
                }
                this.waitOnBarrier(view, "unblock-slaves");
                if (election.isMaster) {
                    this.unblock();
                }
                this.waitOnBarrier(view, "unblock-master");
                this.lastView = view;
                this.makeMasterIfElected(election);
                LOG.info("Election Process Time: {} ms", (Object)(System.currentTimeMillis() - t1));
                this.notifyListener();
            }
            catch (Throwable t) {
                LOG.error("Leadership election is failed for view: {}, {}", (Object)view, (Object)t.getMessage());
                this.blockAndLock();
                this.buffer.erase();
                if (!this.isStopped) {
                    this.replayer.get();
                }
                this.failoverManager.setMaster(false);
                this.await();
                if (this.isStopped) break block9;
                this.onClusterEvent(ClusterEvent.MEMBERSHIP_CHANGED);
            }
        }
    }

    protected void makeMasterIfElected(ElectionResult election) {
        this.failoverManager.setMaster(election.isMaster);
    }

    protected void blockAndLock() {
        if (this.failoverManager.isMaster() && !this.failoverManager.isBlocked()) {
            this.failoverManager.block();
        }
        this.buffer.lockIncoming();
    }

    protected void unblock() {
        if (this.failoverManager.isBlocked()) {
            this.failoverManager.unblock();
        }
    }

    protected void replay(ClusterState state) {
        if (state.latestNode.isPresent()) {
            this.replayer.get();
        }
    }

    protected void unblockMasterOrSynchronizeSlave(ClusterView view, ElectionResult election, ClusterState state) {
        if (election.isMaster && !state.latestNode.isPresent() && !this.config.revenoDataSync().waitAllNodesSync()) {
            this.failoverManager.setMaster(true);
            this.failoverManager.unblock();
        }
        if (state.latestNode.isPresent()) {
            this.modelSynchronizer.execute(view, new StorageTransferModelSync.TransferContext(state.currentTransactionId, state.latestNode.get()));
        }
    }

    protected ClusterState clusterStateCollection(ClusterView view) {
        ClusterState state = this.clusterStateCollector.execute(view);
        if (state.failed) {
            throw new FailoverAbortedException("Unable to gather cluster state, restarting.");
        }
        return state;
    }

    protected ElectionResult leadershipElection(ClusterView view) {
        ElectionResult election = this.leaderElector.execute(view);
        if (election.failed) {
            throw new FailoverAbortedException("Unable to complete voting, restarting.");
        }
        return election;
    }

    protected void rollAndFixJournals(ClusterView view) {
        this.buffer.erase();
        if (this.config.revenoDataSync().mode() == SyncMode.SNAPSHOT) {
            this.snapshotMaker.run();
        }
        this.storageServer.fixJournals(view);
        this.journalsManager.roll(this.lastTransactionId.get().longValue());
    }

    protected void blockIfMaster() {
        this.blockIfMaster(() -> true);
    }

    protected void blockIfMaster(Supplier<Boolean> condition) {
        if (this.failoverManager.isMaster() && condition.get().booleanValue()) {
            this.failoverManager.block();
        }
    }

    private void notifyListener() {
        if (this.failoverListener != null) {
            this.failoverListener.run();
        }
    }

    protected void waitOnBarrier(ClusterView view, String name) {
        this.waitOnBarrier(view, name, this.config.revenoElectionTimeouts().barrierTimeoutNanos());
    }

    protected void waitOnBarrier(ClusterView view, String name, long timeout) {
        LOG.debug("Wait on barrier [{}]", (Object)name);
        GroupBarrier barrier = new GroupBarrier(this.cluster, view, name, timeout);
        if (!barrier.waitOn()) {
            throw new FailoverAbortedException(String.format("Timeout wait on barrier [%s] in view [%s].", name, view));
        }
        LOG.debug("Reached barrier [{}]", (Object)name);
    }

    protected boolean isQuorum(ClusterView view) {
        return view.members().size() != 0 && view.members().size() >= this.config.nodesAddresses().size() / 2;
    }

    protected void await() {
        try {
            Thread.sleep(this.config.revenoElectionTimeouts().ackTimeoutNanos() / 1000000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public FailoverExecutor(Cluster cluster, JournalsManager journalsManager, ClusterFailoverManager failoverManager, StorageTransferServer storageServer, RevenoClusterConfiguration config) {
        this.cluster = cluster;
        this.storageServer = storageServer;
        this.config = config;
        this.journalsManager = journalsManager;
        this.buffer = failoverManager.buffer();
        this.failoverManager = failoverManager;
        ArrayBlockingQueue<Runnable> queue = new ArrayBlockingQueue<Runnable>(500);
        this.electorExecutor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, queue, (ThreadFactory)new NamedThreadFactory("fe-" + config.currentNodeAddress()));
        this.electorExecutor.setRejectedExecutionHandler((r, executor) -> {
            try {
                this.electorExecutor.getQueue().put(r);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        });
    }
}

