/*
 * Decompiled with CFR 0.152.
 */
package org.reveno.atp.clustering.core.components;

import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.reveno.atp.clustering.api.Address;
import org.reveno.atp.clustering.api.Cluster;
import org.reveno.atp.clustering.api.ClusterView;
import org.reveno.atp.clustering.api.message.Message;
import org.reveno.atp.clustering.core.RevenoClusterConfiguration;
import org.reveno.atp.clustering.core.api.ClusterExecutor;
import org.reveno.atp.clustering.core.api.ClusterState;
import org.reveno.atp.clustering.core.api.MessagesReceiver;
import org.reveno.atp.clustering.core.messages.NodeState;
import org.reveno.atp.clustering.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessagingClusterStateCollector
implements ClusterExecutor<ClusterState, Void>,
MessagesReceiver {
    protected Cluster cluster;
    protected Supplier<Long> transactionId;
    protected RevenoClusterConfiguration config;
    protected Map<Address, NodeState> nodesStates = new ConcurrentHashMap<Address, NodeState>();
    protected static final Logger LOG = LoggerFactory.getLogger(MessagingClusterStateCollector.class);
    protected static final Set<Integer> SUBSCRIPTION = new HashSet<Integer>(){
        {
            this.add(197);
        }
    };
    protected static final Comparator<NodeState> STATE_MESSAGE_COMPARATOR = (a, b) -> {
        if (a.transactionId > b.transactionId) {
            return 1;
        }
        if (a.transactionId < b.transactionId) {
            return -1;
        }
        return 0;
    };

    @Override
    public ClusterState execute(ClusterView view, Void context) {
        LOG.info("Cluster state collection [view: {}, nodes: {}]", (Object)view.viewId(), view.members());
        long currentTransactionId = this.transactionId.get();
        if (this.allStatesReceived(view, currentTransactionId)) {
            Optional<NodeState> latestTransactionId = this.nodesStates.values().stream().filter(m -> view.members().contains(m.address())).filter(m -> m.viewId == view.viewId()).max(STATE_MESSAGE_COMPARATOR);
            if (latestTransactionId.isPresent()) {
                LOG.info("Cluster state collection.");
                NodeState stateMessage = latestTransactionId.get();
                if (stateMessage.transactionId > currentTransactionId) {
                    LOG.trace("Need to sync - my txId: {}, latest: {}", (Object)currentTransactionId, (Object)stateMessage.transactionId);
                    return new ClusterState(false, currentTransactionId, Optional.of(stateMessage));
                }
                return new ClusterState(false, currentTransactionId, Optional.empty());
            }
            LOG.trace("Sync node not found [view: {}; txId: {}; states: {}]", new Object[]{view.viewId(), currentTransactionId, this.nodesStates});
            return new ClusterState(true, currentTransactionId, Optional.empty());
        }
        LOG.trace("Not all states received [view: {}; states: {}]", (Object)view.viewId(), this.nodesStates);
        if (view.viewId() == this.cluster.view().viewId()) {
            return (ClusterState)this.execute(view);
        }
        return new ClusterState(true, currentTransactionId, Optional.empty());
    }

    @Override
    public void onMessage(Message message) {
        this.nodesStates.put(message.address(), (NodeState)message);
    }

    @Override
    public Set<Integer> interestedTypes() {
        return SUBSCRIPTION;
    }

    protected boolean allStatesReceived(ClusterView view, long currentTransactionId) {
        NodeState message = new NodeState(view.viewId(), currentTransactionId, this.config.revenoDataSync().mode().getType(), this.config.revenoDataSync().port());
        this.cluster.gateway().send(view.members(), message, this.cluster.gateway().oob());
        return Utils.waitFor(() -> this.nodesStates.keySet().containsAll(view.members()) && this.nodesStates.entrySet().stream().filter(kv -> view.members().contains(kv.getKey())).filter(kv -> ((NodeState)kv.getValue()).viewId == view.viewId()).count() == (long)view.members().size(), this.config.revenoElectionTimeouts().ackTimeoutNanos());
    }

    public MessagingClusterStateCollector(Cluster cluster, Supplier<Long> transactionId, RevenoClusterConfiguration config) {
        this.cluster = cluster;
        this.transactionId = transactionId;
        this.config = config;
    }
}

