/*
 * Decompiled with CFR 0.152.
 */
package org.reveno.atp.clustering.core.components;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import org.reveno.atp.clustering.api.ClusterView;
import org.reveno.atp.clustering.api.InetAddress;
import org.reveno.atp.clustering.api.SyncMode;
import org.reveno.atp.clustering.core.RevenoClusterConfiguration;
import org.reveno.atp.clustering.core.api.ClusterExecutor;
import org.reveno.atp.clustering.core.messages.NodeState;
import org.reveno.atp.core.api.channel.Channel;
import org.reveno.atp.core.api.storage.JournalsStorage;
import org.reveno.atp.core.api.storage.SnapshotStorage;
import org.reveno.atp.utils.Exceptions;
import org.reveno.atp.utils.MeasureUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageTransferModelSync
implements ClusterExecutor<Boolean, TransferContext> {
    protected RevenoClusterConfiguration config;
    protected JournalsStorage storage;
    protected SnapshotStorage snapshots;
    protected static final Logger LOG = LoggerFactory.getLogger(StorageTransferModelSync.class);
    public static final byte TRANSACTIONS = 1;
    public static final byte EVENTS = 2;

    @Override
    public Boolean execute(ClusterView view, TransferContext context) {
        String host = ((InetAddress)context.latestNode.address()).getHost();
        int port = context.latestNode.syncPort;
        InetSocketAddress sad = new InetSocketAddress(host, port);
        if (context.latestNode.syncMode == SyncMode.JOURNALS.getType()) {
            JournalsStorage.JournalStore tempStore = this.storage.nextTempStore();
            JournalsStorage.JournalStore store = this.storage.nextStore(context.latestNode.transactionId);
            if (this.receiveStore(view, context, sad, (byte)1, this.storage.channel(tempStore.getTransactionCommitsAddress())) && this.receiveStore(view, context, sad, (byte)2, this.storage.channel(tempStore.getEventsCommitsAddress()))) {
                this.storage.mergeStores(new JournalsStorage.JournalStore[]{tempStore}, store);
                return true;
            }
            this.storage.deleteStore(tempStore);
            this.storage.deleteStore(store);
            return false;
        }
        if (context.latestNode.syncMode == SyncMode.SNAPSHOT.getType()) {
            SnapshotStorage.SnapshotStore tempStore = this.snapshots.nextTempSnapshotStore();
            SnapshotStorage.SnapshotStore snapshotStore = this.snapshots.nextSnapshotStore();
            if (this.receiveStore(view, context, sad, (byte)0, this.snapshots.snapshotChannel(tempStore.getSnapshotPath()))) {
                this.snapshots.move(tempStore, snapshotStore);
                return true;
            }
            this.snapshots.removeSnapshotStore(tempStore);
            this.snapshots.removeSnapshotStore(snapshotStore);
        }
        throw new IllegalArgumentException("Unknown transfer mode.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean receiveStore(ClusterView view, TransferContext context, SocketAddress sad, byte type, Channel channel) {
        try {
            SocketChannel sc = SocketChannel.open();
            if (!sc.connect(sad)) {
                LOG.error("STF SYNC: can't establish connection to {}", (Object)sad);
                boolean bl = false;
                return bl;
            }
            sc.configureBlocking(true);
            ByteBuffer message = ByteBuffer.allocate(17);
            message.putLong(view.viewId());
            message.put(type);
            message.putLong(context.transactionId);
            message.flip();
            int size = sc.write(message);
            LOG.debug("STF SYNC: sent {} to StorageTransfer server {}", (Object)size, (Object)sc);
            ByteBuffer data = ByteBuffer.allocate(MeasureUtils.kb((int)64));
            int nread = 0;
            while (nread != -1) {
                try {
                    nread = sc.read(data);
                    data.flip();
                    LOG.debug("STF SYNC: received next {} bytes from {}", (Object)data.limit(), (Object)sad);
                    channel.write(b -> b.writeFromBuffer(data), true);
                }
                catch (IOException e) {
                    LOG.error(e.getMessage(), (Throwable)e);
                    throw Exceptions.runtime((Throwable)e);
                }
                data.clear();
            }
        }
        catch (Throwable t) {
            LOG.error("STF SYNC: Can't sync with remote node " + sad, t);
            boolean bl = false;
            return bl;
        }
        finally {
            LOG.debug("STF SYNC: received latest store from StoreServer.");
            channel.close();
        }
        return true;
    }

    public StorageTransferModelSync(RevenoClusterConfiguration config, JournalsStorage storage, SnapshotStorage snapshots) {
        this.config = config;
        this.storage = storage;
        this.snapshots = snapshots;
    }

    public static class TransferContext {
        public final long transactionId;
        public final NodeState latestNode;

        public TransferContext(long transactionId, NodeState latestNode) {
            this.transactionId = transactionId;
            this.latestNode = latestNode;
        }
    }
}

