/*
 * Decompiled with CFR 0.152.
 */
package org.reveno.atp.clustering.core.jgroups;

import java.net.UnknownHostException;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.JChannel;
import org.jgroups.PhysicalAddress;
import org.reveno.atp.clustering.api.InetAddress;
import org.reveno.atp.clustering.core.RevenoClusterConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JChannelHelper {
    protected static final Logger LOG = LoggerFactory.getLogger(JChannelHelper.class);

    public static InetAddress physicalAddress(JChannel channel, RevenoClusterConfiguration config, Address address) {
        java.net.InetAddress inet;
        PhysicalAddress physicalAddress;
        long count = 0L;
        while ((physicalAddress = (PhysicalAddress)channel.down(new Event(87, (Object)address))) == null) {
            if (count++ % 1000L != 0L) continue;
            LOG.error("Still can't retrieve physical address of node");
        }
        String[] parts = physicalAddress.toString().split(":");
        try {
            inet = java.net.InetAddress.getByName(parts[0]);
        }
        catch (UnknownHostException e) {
            return null;
        }
        return config.nodesAddresses().stream().map(a -> (InetAddress)a).filter(a -> a.getHost().equals(inet.getHostAddress()) && a.getPort() == Integer.parseInt(parts[1])).findFirst().orElse(null);
    }
}

