/*
 * Decompiled with CFR 0.152.
 */
package org.reveno.atp.clustering.core.jgroups;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jgroups.Channel;
import org.jgroups.ChannelListener;
import org.jgroups.Header;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.conf.ClassConfigurator;
import org.jgroups.protocols.RSVP;
import org.reveno.atp.clustering.api.Address;
import org.reveno.atp.clustering.api.Cluster;
import org.reveno.atp.clustering.api.ClusterConnector;
import org.reveno.atp.clustering.api.ClusterEvent;
import org.reveno.atp.clustering.api.ClusterView;
import org.reveno.atp.clustering.api.Flag;
import org.reveno.atp.clustering.api.InetAddress;
import org.reveno.atp.clustering.api.message.Marshaller;
import org.reveno.atp.clustering.core.RevenoClusterConfiguration;
import org.reveno.atp.clustering.core.jgroups.JChannelHelper;
import org.reveno.atp.clustering.core.jgroups.JChannelReceiver;
import org.reveno.atp.clustering.core.marshallers.JsonMarshaller;
import org.reveno.atp.clustering.util.Tuple;
import org.reveno.atp.core.api.channel.Buffer;
import org.reveno.atp.core.channel.NettyBasedBuffer;
import org.reveno.atp.utils.Exceptions;
import org.reveno.atp.utils.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JGroupsCluster
implements Cluster {
    protected volatile ClusterView currentView = ClusterView.EMPTY_VIEW;
    protected volatile Marshaller marshaller = new JsonMarshaller();
    protected volatile boolean isConnected = false;
    protected RevenoClusterConfiguration config;
    protected Consumer<ClusterEvent> clusterEventsListener = e -> {};
    protected JGroupsConnector connector = new JGroupsConnector();
    protected Int2ObjectMap<List<Consumer<org.reveno.atp.clustering.api.message.Message>>> receivers = new Int2ObjectOpenHashMap();
    protected Map<InetAddress, org.jgroups.Address> addressMap = new HashMap<InetAddress, org.jgroups.Address>();
    protected JChannel channel;
    protected static final Logger LOG = LoggerFactory.getLogger(JGroupsCluster.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect() {
        if (this.isConnected) {
            return;
        }
        Class<ClassConfigurator> clazz = ClassConfigurator.class;
        synchronized (ClassConfigurator.class) {
            if (ClassConfigurator.get((short)6844) == null) {
                ClassConfigurator.add((short)6844, ClusterMessageHeader.class);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            try {
                ((JChannelReceiver)this.channel.getReceiver()).addReceiver(msg -> {
                    if (msg.getHeader((short)6844) != null) {
                        NettyBasedBuffer buffer = new NettyBasedBuffer(msg.getLength(), msg.getLength(), false);
                        buffer.writeBytes(msg.getBuffer());
                        org.reveno.atp.clustering.api.message.Message message = this.marshaller.unmarshall((Buffer)buffer);
                        message.address(JChannelHelper.physicalAddress(this.channel, this.config, msg.getSrc()));
                        this.receivers(message.type()).forEach(c -> c.accept(message));
                    }
                });
                ((JChannelReceiver)this.channel.getReceiver()).addViewAcceptor(view -> {
                    LOG.info("New view: {}, size: {}", view, (Object)view.getMembers().size());
                    List<Address> members = view.getMembers().stream().map(a -> new Tuple<org.jgroups.Address, InetAddress>((org.jgroups.Address)a, JChannelHelper.physicalAddress(this.channel, this.config, a))).filter(t -> t.getVal2() != null).filter(t -> this.config.nodesAddresses().contains(t.getVal2())).peek(t -> this.addressMap.put((InetAddress)t.getVal2(), (org.jgroups.Address)t.getVal1())).map(Tuple::getVal2).collect(Collectors.toList());
                    this.currentView = new ClusterView(view.getViewId().getId(), members);
                    LOG.info("New view: {}", (Object)this.currentView);
                    this.clusterEventsListener.accept(ClusterEvent.MEMBERSHIP_CHANGED);
                });
                this.channel.addChannelListener(new ChannelListener(){

                    public void channelConnected(Channel channel) {
                        JGroupsCluster.this.clusterEventsListener.accept(ClusterEvent.CONNECTED);
                    }

                    public void channelDisconnected(Channel channel) {
                        JGroupsCluster.this.clusterEventsListener.accept(ClusterEvent.DISCONNECTED);
                    }

                    public void channelClosed(Channel channel) {
                        JGroupsCluster.this.clusterEventsListener.accept(ClusterEvent.CLOSED);
                    }
                });
                this.channel.connect("rvno_jg");
            }
            catch (Exception e) {
                throw Exceptions.runtime((Throwable)e);
            }
            finally {
                this.isConnected = true;
            }
            return;
        }
    }

    @Override
    public void disconnect() {
        this.channel.close();
    }

    @Override
    public boolean isConnected() {
        return this.channel.isConnected();
    }

    @Override
    public ClusterConnector gateway() {
        return this.connector;
    }

    @Override
    public void marshallWith(Marshaller marshaller) {
        Preconditions.checkNotNull((Object)marshaller, (Object)"Marshaller should be non-null.");
        this.marshaller = marshaller;
    }

    @Override
    public void listenEvents(Consumer<ClusterEvent> consumer) {
        this.clusterEventsListener = consumer;
    }

    @Override
    public ClusterView view() {
        return this.currentView;
    }

    protected List<Consumer<org.reveno.atp.clustering.api.message.Message>> receivers(int type) {
        return (List)this.receivers.computeIfAbsent((Object)type, a -> new CopyOnWriteArrayList());
    }

    public JGroupsCluster(RevenoClusterConfiguration config, JChannel channel) {
        this.config = config;
        this.channel = channel;
    }

    public static class ClusterMessageHeader
    extends Header {
        public static final short ID = 6844;

        public int size() {
            return 0;
        }

        public void writeTo(DataOutput out) throws Exception {
        }

        public void readFrom(DataInput in) throws Exception {
        }
    }

    public class JGroupsConnector
    implements ClusterConnector {
        @Override
        public void send(List<Address> dest, org.reveno.atp.clustering.api.message.Message message) {
            this.send(dest, message, Collections.emptySet());
        }

        @Override
        public void send(List<Address> dest, org.reveno.atp.clustering.api.message.Message message, Set<Flag> flags) {
            NettyBasedBuffer buffer = new NettyBasedBuffer(false);
            JGroupsCluster.this.marshaller.marshall((Buffer)buffer, message);
            byte[] data = buffer.readBytes(buffer.length());
            dest.stream().filter(d -> JGroupsCluster.this.addressMap.containsKey(d)).map(d -> JGroupsCluster.this.addressMap.get(d)).forEach(a -> {
                Message msg = new Message(a, null, data);
                if (flags.contains((Object)Flag.OUT_OF_BOUND)) {
                    msg.setFlag(new Message.Flag[]{Message.Flag.OOB});
                }
                if (!flags.contains((Object)Flag.RSVP)) {
                    msg.setFlag(new Message.Flag[]{Message.Flag.NO_RELIABILITY});
                } else if (JGroupsCluster.this.channel.getProtocolStack().findProtocol(RSVP.class) != null) {
                    msg.setFlag(new Message.Flag[]{Message.Flag.RSVP});
                }
                msg.setTransientFlag(new Message.TransientFlag[]{Message.TransientFlag.DONT_LOOPBACK});
                msg.putHeader((short)6844, (Header)new ClusterMessageHeader());
                try {
                    JGroupsCluster.this.channel.send(msg);
                }
                catch (Exception e) {
                    throw Exceptions.runtime((Throwable)e);
                }
            });
        }

        @Override
        public <T extends org.reveno.atp.clustering.api.message.Message> void receive(int type, Consumer<T> consumer) {
            JGroupsCluster.this.receivers(type).add(consumer);
        }

        @Override
        public <T extends org.reveno.atp.clustering.api.message.Message> void receive(int type, Predicate<T> filter, Consumer<T> consumer) {
            JGroupsCluster.this.receivers(type).add(m -> {
                if (filter.test(m)) {
                    consumer.accept(m);
                }
            });
        }

        @Override
        public <T extends org.reveno.atp.clustering.api.message.Message> void unsubscribe(int type, Consumer<T> consumer) {
            JGroupsCluster.this.receivers(type).remove(consumer);
        }
    }
}

