/*
 * Decompiled with CFR 0.152.
 */
package org.reveno.atp.clustering.core.jgroups;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import org.jgroups.Message;
import org.jgroups.ReceiverAdapter;
import org.jgroups.View;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JChannelReceiver
extends ReceiverAdapter {
    protected List<Consumer<Message>> receivers = new CopyOnWriteArrayList<Consumer<Message>>();
    protected List<Consumer<View>> viewAcceptors = new CopyOnWriteArrayList<Consumer<View>>();
    protected static final Logger LOG = LoggerFactory.getLogger(JChannelReceiver.class);

    public void addReceiver(Consumer<Message> receiver) {
        this.receivers.add(receiver);
    }

    public void addViewAcceptor(Consumer<View> acceptor) {
        this.viewAcceptors.add(acceptor);
    }

    public void receive(Message msg) {
        try {
            this.receivers.forEach(r -> r.accept(msg));
        }
        catch (Throwable t) {
            LOG.error(t.getMessage(), t);
        }
    }

    public void viewAccepted(View view) {
        try {
            this.viewAcceptors.forEach(a -> a.accept(view));
        }
        catch (Throwable t) {
            LOG.error(t.getMessage(), t);
        }
    }
}

