/*
 * Decompiled with CFR 0.152.
 */
package org.reveno.atp.clustering.core.providers;

import java.util.Properties;
import org.reveno.atp.clustering.api.ClusterBuffer;
import org.reveno.atp.clustering.core.jgroups.JGroupsBuffer;
import org.reveno.atp.clustering.core.providers.JGroupsClusterProvider;

public class UnicastAllProvider
extends JGroupsClusterProvider {
    @Override
    ClusterBuffer createBuffer() {
        return new JGroupsBuffer(this.config, this.channel);
    }

    @Override
    void setProperties(Properties properties) {
        properties.setProperty("max.retransmit.time", Integer.toString(this.config.revenoUnicast().maxRetransmitTimeMillis()));
        properties.setProperty("retransmit.interval", Integer.toString(this.config.revenoUnicast().retransmitIntervalMillis()));
        properties.setProperty("nodes.ping.timeout", Integer.toString(this.config.revenoUnicast().pingTimeoutMillis()));
        properties.setProperty("jgroups.threads.min", Integer.toString(this.config.revenoUnicast().minReceiveThreads()));
        properties.setProperty("jgroups.threads.max", Integer.toString(this.config.revenoUnicast().maxReceiveThreads()));
        if (this.config.revenoUnicast().receiveQueueMaxSize() == 0) {
            properties.setProperty("jgroups.threads.queue", "false");
        } else {
            properties.setProperty("jgroups.threads.queue", "true");
            properties.setProperty("jgroups.threads.queue.size", Integer.toString(this.config.revenoUnicast().receiveQueueMaxSize()));
        }
        properties.setProperty("max.read.batch.size", Integer.toString(this.config.revenoUnicast().maxReadBatchMessages()));
        properties.setProperty("tcp.send_buf_size", Integer.toString(this.config.revenoUnicast().sendBufferSize()));
        properties.setProperty("tcp.recv_buf_size", Integer.toString(this.config.revenoUnicast().receiveBufferSize()));
    }

    public UnicastAllProvider() {
        this.jGroupsConfigFile = "classpath:/tcp.xml";
    }

    public UnicastAllProvider(String jGroupsConfigFile) {
        this.jGroupsConfigFile = jGroupsConfigFile;
    }
}

