/*
 * Decompiled with CFR 0.152.
 */
package org.reveno.atp.clustering.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.concurrent.locks.LockSupport;
import java.util.function.Supplier;
import org.reveno.atp.utils.Exceptions;

public abstract class Utils {
    public static boolean waitFor(Supplier<Boolean> condition, long timeoutNanos) {
        long start = System.nanoTime();
        boolean result = false;
        while (System.nanoTime() - start < timeoutNanos && !(result = condition.get().booleanValue())) {
            LockSupport.parkNanos(1L);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[] getFreePorts(int portNumber) {
        try {
            int[] result = new int[portNumber];
            ArrayList<ServerSocket> servers = new ArrayList<ServerSocket>(portNumber);
            try {
                for (int i = 0; i < portNumber; ++i) {
                    ServerSocket tempServer = new ServerSocket(0);
                    servers.add(tempServer);
                    result[i] = tempServer.getLocalPort();
                }
            }
            finally {
                for (ServerSocket server : servers) {
                    try {
                        server.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            return result;
        }
        catch (Throwable t) {
            throw Exceptions.runtime((Throwable)t);
        }
    }

    public static boolean isNullOrEmpty(String str) {
        return str == null || str.trim().equals("");
    }

    public static void write(String str, File file) throws FileNotFoundException {
        try (PrintStream out = new PrintStream(new FileOutputStream(file));){
            out.print(str);
        }
    }
}

