/*
 * Decompiled with CFR 0.152.
 */
package org.reveno.atp.clustering.core;

import java.io.File;
import java.util.concurrent.CountDownLatch;
import org.reveno.atp.api.domain.Repository;
import org.reveno.atp.clustering.api.Cluster;
import org.reveno.atp.clustering.api.ClusterBuffer;
import org.reveno.atp.clustering.api.ClusterConfiguration;
import org.reveno.atp.clustering.api.ClusterStateInfo;
import org.reveno.atp.clustering.api.ClusterView;
import org.reveno.atp.clustering.api.message.Marshaller;
import org.reveno.atp.clustering.core.ClusterFailoverManager;
import org.reveno.atp.clustering.core.FailoverExecutor;
import org.reveno.atp.clustering.core.RevenoClusterConfiguration;
import org.reveno.atp.clustering.core.api.ClusterExecutor;
import org.reveno.atp.clustering.core.api.ClusterState;
import org.reveno.atp.clustering.core.api.ElectionResult;
import org.reveno.atp.clustering.core.api.StorageTransferServer;
import org.reveno.atp.clustering.core.buffer.ClusterProvider;
import org.reveno.atp.clustering.core.components.FileStorageTransferServer;
import org.reveno.atp.clustering.core.components.MessagingClusterStateCollector;
import org.reveno.atp.clustering.core.components.MessagingMasterSlaveElector;
import org.reveno.atp.clustering.core.components.StorageTransferModelSync;
import org.reveno.atp.clustering.core.marshallers.NativeMarshaller;
import org.reveno.atp.clustering.core.providers.MulticastAllProvider;
import org.reveno.atp.clustering.core.providers.UnicastAllProvider;
import org.reveno.atp.core.Engine;
import org.reveno.atp.core.api.FailoverManager;
import org.reveno.atp.core.api.serialization.TransactionInfoSerializer;
import org.reveno.atp.core.api.storage.FoldersStorage;
import org.reveno.atp.core.api.storage.JournalsStorage;
import org.reveno.atp.core.api.storage.SnapshotStorage;
import org.reveno.atp.core.engine.WorkflowEngine;
import org.reveno.atp.core.storage.FileSystemStorage;
import org.reveno.atp.utils.Exceptions;

public class ClusterEngine
extends Engine {
    protected ClusterStateInfo stateInfo = new ClusterStateInfo(){

        @Override
        public boolean isMaster() {
            return ClusterEngine.this.failoverManager != null && ClusterEngine.this.failoverManager.isMaster();
        }

        @Override
        public boolean isBlocked() {
            return ClusterEngine.this.failoverManager != null && ClusterEngine.this.failoverManager.isBlocked();
        }

        @Override
        public ClusterView currentView() {
            return ClusterEngine.this.cluster == null ? null : ClusterEngine.this.cluster.view();
        }
    };
    protected RevenoClusterConfiguration configuration = new RevenoClusterConfiguration();
    protected ClusterProvider clusterProvider;
    protected StorageTransferServer storageTransferServer;
    protected ClusterBuffer buffer;
    protected Cluster cluster;
    protected ClusterFailoverManager failoverManager;
    protected FailoverExecutor failoverExecutor;

    public ClusterEngine(FoldersStorage foldersStorage, JournalsStorage journalsStorage, SnapshotStorage snapshotStorage, ClassLoader classLoader) {
        super(foldersStorage, journalsStorage, snapshotStorage, classLoader);
    }

    public ClusterEngine(String baseDir, ClassLoader classLoader) {
        super(baseDir, classLoader);
    }

    public ClusterEngine(File baseDir, ClassLoader classLoader) {
        super(baseDir, classLoader);
    }

    public ClusterEngine(File baseDir, ClassLoader classLoader, ClusterProvider clusterProvider) {
        super(baseDir, classLoader);
        this.clusterProvider = clusterProvider;
    }

    public ClusterEngine(File baseDir) {
        super(baseDir);
    }

    public ClusterEngine(String baseDir) {
        super(baseDir);
    }

    public ClusterEngine(String baseDir, ClusterProvider clusterProvider) {
        super(baseDir);
        this.clusterProvider = clusterProvider;
    }

    public ClusterEngine(FoldersStorage foldersStorage, JournalsStorage journalsStorage, SnapshotStorage snapshotStorage, ClassLoader classLoader, ClusterProvider clusterProvider) {
        super(foldersStorage, journalsStorage, snapshotStorage, classLoader);
        this.clusterProvider = clusterProvider;
    }

    public ClusterEngine(FoldersStorage foldersStorage, JournalsStorage journalsStorage, SnapshotStorage snapshotStorage, ClassLoader classLoader, ClusterProvider clusterProvider, StorageTransferServer server) {
        this(foldersStorage, journalsStorage, snapshotStorage, classLoader, clusterProvider);
        this.storageTransferServer = server;
    }

    public ClusterConfiguration clusterConfiguration() {
        return this.configuration;
    }

    public void startup() {
        if (this.clusterProvider == null) {
            switch (this.configuration.commandsXmitTransport()) {
                case UNICAST: {
                    this.clusterProvider = new UnicastAllProvider();
                    break;
                }
                case MULTICAST: {
                    this.clusterProvider = new MulticastAllProvider();
                }
            }
        }
        CountDownLatch failoverWaiter = new CountDownLatch(1);
        this.clusterProvider.initialize(this.configuration);
        this.buffer = this.clusterProvider.retrieveBuffer();
        this.cluster = this.clusterProvider.retrieveCluster();
        this.failoverManager = new ClusterFailoverManager((TransactionInfoSerializer)this.serializer, this.buffer);
        if (this.storageTransferServer == null) {
            this.storageTransferServer = new FileStorageTransferServer(this.configuration, (FileSystemStorage)this.journalsStorage);
        }
        super.startup();
        this.storageTransferServer.startup();
        this.failoverExecutor = new FailoverExecutor(this.cluster, this.journalsManager, this.failoverManager, this.storageTransferServer, this.configuration);
        this.failoverExecutor.snapshotMaker(() -> ((ClusterEngine)this).snapshotAll());
        this.failoverExecutor.replayer(this::replay);
        this.failoverExecutor.leaderElector(this.leadershipExecutor());
        this.failoverExecutor.clusterStateCollector(this.clusterStateCollector());
        this.failoverExecutor.modelSynchronizer(this.transferModelSync());
        this.failoverExecutor.lastTransactionId(() -> ((WorkflowEngine)this.workflowEngine).getLastTransactionId());
        this.failoverExecutor.marshaller(this.marshaller());
        this.failoverExecutor.failoverListener(failoverWaiter::countDown);
        this.failoverExecutor.init();
        this.buffer.connect();
        this.cluster.connect();
        this.failoverExecutor.startElectionProcess();
        try {
            failoverWaiter.await();
        }
        catch (InterruptedException e) {
            throw Exceptions.runtime((Throwable)e);
        }
    }

    public void shutdown() {
        this.isStarted = false;
        this.failoverExecutor.stop();
        this.storageTransferServer.shutdown();
        this.buffer.disconnect();
        this.cluster.disconnect();
        super.shutdown();
    }

    public ClusterStateInfo clusterStateInfo() {
        return this.stateInfo;
    }

    protected FailoverManager failoverManager() {
        return this.failoverManager;
    }

    public boolean isElectedInCluster() {
        return this.cluster != null && this.failoverExecutor != null && this.failoverExecutor.lastView().viewId() > 0L;
    }

    protected ClusterExecutor<ElectionResult, Void> leadershipExecutor() {
        return new MessagingMasterSlaveElector(this.cluster, this.configuration);
    }

    protected ClusterExecutor<ClusterState, Void> clusterStateCollector() {
        return new MessagingClusterStateCollector(this.cluster, () -> ((WorkflowEngine)this.workflowEngine).getLastTransactionId(), this.configuration);
    }

    protected ClusterExecutor<Boolean, StorageTransferModelSync.TransferContext> transferModelSync() {
        return new StorageTransferModelSync(this.configuration, this.journalsStorage, this.snapshotStorage);
    }

    protected Marshaller marshaller() {
        return new NativeMarshaller();
    }

    protected long replay() {
        this.repository = this.factory.create(this.loadLastSnapshot());
        this.viewsProcessor.erase();
        this.viewsProcessor.process((Repository)this.repository);
        this.workflowEngine.setLastTransactionId(this.restorer.restore(this.repository).getLastTransactionId());
        this.workflowContext.repository(this.repository);
        return this.workflowEngine.getLastTransactionId();
    }
}

