/*
 * Decompiled with CFR 0.152.
 */
package org.reveno.atp.clustering.core.components;

import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.reveno.atp.clustering.api.Address;
import org.reveno.atp.clustering.api.Cluster;
import org.reveno.atp.clustering.api.ClusterView;
import org.reveno.atp.clustering.core.messages.BarrierMessage;
import org.reveno.atp.clustering.core.messages.BarrierPassed;
import org.reveno.atp.utils.Exceptions;
import org.reveno.atp.utils.SignalBarrier;

public class GroupBarrier {
    protected Cluster cluster;
    protected ClusterView view;
    protected String id;
    protected long timeoutNanos;
    protected Set<Address> came = Collections.newSetFromMap(new ConcurrentHashMap());
    protected Set<Address> passed = Collections.newSetFromMap(new ConcurrentHashMap());
    protected SignalBarrier cameBarrier = new SignalBarrier();
    protected SignalBarrier passedBarrier = new SignalBarrier();
    protected static final long WAIT_TIMEOUT_NANOS = 200000L;

    public boolean waitOn() {
        boolean result = this.waitOnGroup();
        this.cluster.gateway().unsubscribe(178, this::tryPassed);
        this.cluster.gateway().unsubscribe(161, this::tryCame);
        return result;
    }

    private boolean waitOnGroup() {
        long start = System.nanoTime();
        Optional<Boolean> came = Optional.empty();
        while (!came.isPresent() && this.isSynced() && this.view.members().size() > 0) {
            this.ackAll();
            came = this.waitFor(this.cameBarrier, came);
            if (!came.isPresent() && this.allCame()) {
                came = Optional.of(true);
            }
            if (Math.abs(System.nanoTime() - start) <= this.timeoutNanos) continue;
            return false;
        }
        this.ackAll();
        if (came.isPresent()) {
            if (((Boolean)came.get()).booleanValue()) {
                Optional<Boolean> passed = Optional.empty();
                while (!passed.isPresent() && this.isSynced()) {
                    this.ackPassed();
                    passed = this.waitFor(this.passedBarrier, passed);
                    if (!passed.isPresent() && this.allPassed()) {
                        passed = Optional.of(true);
                    }
                    if (Math.abs(System.nanoTime() - start) <= this.timeoutNanos) continue;
                    return false;
                }
                return passed.isPresent() && (Boolean)passed.get() != false;
            }
            return false;
        }
        return this.view.members().size() <= 0;
    }

    protected Optional<Boolean> waitFor(SignalBarrier barrier, Optional<Boolean> came) {
        try {
            barrier.awaitNanos(200000L);
        }
        catch (InterruptedException e) {
            throw Exceptions.runtime((Throwable)e);
        }
        if (!this.isSynced()) {
            came = Optional.of(false);
        }
        return came;
    }

    public GroupBarrier(Cluster cluster, ClusterView view, String name, long timeoutNanos) {
        this.cluster = cluster;
        this.view = view;
        this.id = name + view.viewId();
        this.timeoutNanos = timeoutNanos;
        cluster.gateway().receive(161, m -> m.id.equals(this.id) && this.isSynced(), this::tryCame);
        cluster.gateway().receive(178, m -> m.id.equals(this.id) && this.isSynced(), this::tryPassed);
    }

    protected void tryPassed(BarrierPassed m) {
        this.passed.add(m.address());
        if (this.allPassed()) {
            this.passedBarrier.signal();
        }
    }

    protected void tryCame(BarrierMessage m) {
        this.came.add(m.address());
        if (this.allCame()) {
            this.cameBarrier.signal();
        }
    }

    protected boolean allCame() {
        return this.came.containsAll(this.view.members());
    }

    protected boolean allPassed() {
        return this.passed.containsAll(this.view.members());
    }

    protected void ackAll() {
        this.cluster.gateway().send(this.view.members(), new BarrierMessage(this.id));
    }

    protected void ackPassed() {
        this.cluster.gateway().send(this.view.members(), new BarrierPassed(this.id));
    }

    protected boolean isSynced() {
        return this.cluster.isConnected() && this.cluster.view().viewId() == this.view.viewId();
    }
}

