/*
 * Decompiled with CFR 0.152.
 */
package org.reveno.atp.clustering.core.jgroups;

import java.io.DataInput;
import java.io.DataOutput;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jgroups.Address;
import org.jgroups.Header;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.conf.ClassConfigurator;
import org.reveno.atp.clustering.api.ClusterBuffer;
import org.reveno.atp.clustering.api.ClusterEvent;
import org.reveno.atp.clustering.api.ClusterView;
import org.reveno.atp.clustering.api.IOMode;
import org.reveno.atp.clustering.api.InetAddress;
import org.reveno.atp.clustering.core.RevenoClusterConfiguration;
import org.reveno.atp.clustering.core.components.AbstractClusterBuffer;
import org.reveno.atp.clustering.core.jgroups.JChannelHelper;
import org.reveno.atp.clustering.core.jgroups.JChannelReceiver;
import org.reveno.atp.clustering.util.Tuple;
import org.reveno.atp.core.api.channel.Buffer;
import org.reveno.atp.core.api.serialization.TransactionInfoSerializer;
import org.reveno.atp.core.channel.NettyBasedBuffer;
import org.reveno.atp.utils.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JGroupsBuffer
extends AbstractClusterBuffer
implements ClusterBuffer {
    protected JChannel channel;
    protected RevenoClusterConfiguration config;
    protected TransactionInfoSerializer serializer;
    protected IOMode restrictOn = null;
    protected volatile boolean isConnected = false;
    protected volatile boolean isLocked = false;
    protected volatile List<AddressPair> addresses = new ArrayList<AddressPair>();
    protected volatile View lastView = null;
    protected Consumer<List<Object>> messageListener = l -> {};
    protected Buffer receiveBuffer = new NettyBasedBuffer();
    protected Logger LOG = LoggerFactory.getLogger(JGroupsBuffer.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect() {
        if (this.isConnected) {
            return;
        }
        Class<ClassConfigurator> clazz = ClassConfigurator.class;
        synchronized (ClassConfigurator.class) {
            if (ClassConfigurator.get((short)2732) == null) {
                ClassConfigurator.add((short)2732, ClusterBufferHeader.class);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            try {
                ((JChannelReceiver)this.channel.getReceiver()).addReceiver(msg -> {
                    if (msg.getHeader((short)2732) != null && !this.isLocked) {
                        this.receiveBuffer.writeBytes(msg.getBuffer());
                        this.messageListener.accept(this.serializer.deserializeCommands(this.receiveBuffer));
                        this.receiveBuffer.clear();
                    }
                });
                ((JChannelReceiver)this.channel.getReceiver()).addViewAcceptor(this::rebuildAddresses);
            }
            catch (Exception e) {
                throw Exceptions.runtime((Throwable)e);
            }
            finally {
                this.isConnected = true;
            }
            return;
        }
    }

    @Override
    public void disconnect() {
        this.channel.disconnect();
    }

    @Override
    public void onView(ClusterView view) {
    }

    @Override
    public void messageNotifier(TransactionInfoSerializer serializer, Consumer<List<Object>> listener) {
        this.serializer = serializer;
        this.messageListener = listener;
    }

    @Override
    public void failoverNotifier(Consumer<ClusterEvent> listener) {
    }

    @Override
    public void lockIncoming() {
        this.isLocked = true;
    }

    @Override
    public void unlockIncoming() {
        this.isLocked = false;
    }

    @Override
    public void erase() {
    }

    @Override
    public void prepare() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean replicate() {
        if (this.lastView == null || !this.channel.getView().equals((Object)this.lastView)) {
            this.rebuildAddresses(this.channel.getView());
        }
        byte[] data = this.sendBuffer.readBytes(this.sendBuffer.length());
        try {
            this.addresses.forEach(p -> {
                if (this.restrictOn != null && p.mode != this.restrictOn) {
                    return;
                }
                Message msg = new Message(p.address, null, data);
                msg.setTransientFlag(new Message.TransientFlag[]{Message.TransientFlag.DONT_LOOPBACK});
                msg.putHeader((short)2732, (Header)new ClusterBufferHeader());
                if (p.mode == IOMode.ASYNC_UNRELIABLE) {
                    msg.setFlag(new Message.Flag[]{Message.Flag.NO_RELIABILITY});
                }
                try {
                    this.channel.send(msg);
                }
                catch (Exception e) {
                    this.LOG.error("replicate", (Throwable)e);
                    throw Exceptions.runtime((Throwable)e);
                }
            });
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.sendBuffer.clear();
        }
        return true;
    }

    protected void rebuildAddresses(View view) {
        this.addresses = view.getMembers().stream().map(a -> new Tuple<Address, InetAddress>((Address)a, JChannelHelper.physicalAddress(this.channel, this.config, a))).filter(t -> t.getVal2() != null).filter(t -> this.config.nodesAddresses().contains(t.getVal2())).map(t -> new AddressPair((Address)t.getVal1(), ((InetAddress)t.getVal2()).getAddressType())).sorted((a, b) -> {
            if (a.mode == IOMode.ASYNC_UNRELIABLE) {
                return 1;
            }
            return -1;
        }).collect(Collectors.toList());
        this.lastView = view;
        this.LOG.info("JGroups Buffer members: {}", (Object)this.addresses.size());
    }

    public JGroupsBuffer(RevenoClusterConfiguration config, JChannel channel) {
        this(config, channel, Optional.empty());
    }

    public JGroupsBuffer(RevenoClusterConfiguration config, JChannel channel, Optional<IOMode> restrictOn) {
        this.channel = channel;
        this.config = config;
        this.restrictOn = restrictOn.orElse(null);
    }

    protected static class AddressPair {
        public final Address address;
        public final IOMode mode;

        public AddressPair(Address address, IOMode mode) {
            this.address = address;
            this.mode = mode;
        }
    }

    public static class ClusterBufferHeader
    extends Header {
        public static final short ID = 2732;

        public int size() {
            return 0;
        }

        public void writeTo(DataOutput out) throws Exception {
        }

        public void readFrom(DataInput in) throws Exception {
        }
    }
}

