/*
 * Decompiled with CFR 0.152.
 */
package org.reveno.atp.clustering.core.marshallers;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.reveno.atp.clustering.api.message.Marshaller;
import org.reveno.atp.clustering.api.message.Message;
import org.reveno.atp.core.api.channel.Buffer;
import org.reveno.atp.utils.Exceptions;

public class JsonMarshaller
implements Marshaller {
    protected ObjectMapper mapper = new ObjectMapper();

    @Override
    public void marshall(Buffer buffer, Message message) {
        try {
            byte[] data = this.mapper.writeValueAsBytes((Object)new MessageWrapper(message));
            buffer.writeInt(data.length);
            buffer.writeBytes(data);
        }
        catch (JsonProcessingException e) {
            throw Exceptions.runtime((Throwable)e);
        }
    }

    @Override
    public Message unmarshall(Buffer buffer) {
        try {
            byte[] data = new byte[buffer.readInt()];
            buffer.readBytes(data, 0, data.length);
            return ((MessageWrapper)this.mapper.readValue((byte[])data, MessageWrapper.class)).message;
        }
        catch (IOException e) {
            throw Exceptions.runtime((Throwable)e);
        }
    }

    public JsonMarshaller() {
        this.mapper.enableDefaultTyping(ObjectMapper.DefaultTyping.OBJECT_AND_NON_CONCRETE);
        this.mapper.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.ANY);
    }

    protected static class MessageWrapper {
        public Message message;

        public MessageWrapper(Message message) {
            this.message = message;
        }

        public MessageWrapper() {
        }
    }
}

