/*
 * Decompiled with CFR 0.152.
 */
package org.reveno.atp.clustering.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.reveno.atp.utils.Exceptions;
import org.w3c.dom.Document;

public abstract class ResourceLoader {
    public static final String PROPERTIES_REGEX = "\\$\\{(?<ctn>[^}]*)\\}";
    protected static final Pattern PROPERTIES_PATTERN = Pattern.compile("\\$\\{(?<ctn>[^}]*)\\}");

    public static Document loadXMLFromString(String xml) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.parse(new ByteArrayInputStream(xml.getBytes()));
    }

    public static String loadResource(File file, Properties properties) {
        try {
            return ResourceLoader.loadResource(new FileInputStream(file), properties);
        }
        catch (FileNotFoundException e) {
            throw Exceptions.runtime((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadResource(InputStream stream, Properties properties) {
        try {
            String content = ResourceLoader.streamToString(stream);
            Matcher match = PROPERTIES_PATTERN.matcher(content);
            StringBuffer sb = new StringBuffer();
            while (match.find()) {
                String value = match.group("ctn");
                String[] split = value.split(":");
                if (properties.containsKey(split[0])) {
                    String prop = properties.getProperty(split[0]);
                    match.appendReplacement(sb, prop);
                    continue;
                }
                if (split.length <= 1) continue;
                match.appendReplacement(sb, split[1]);
            }
            match.appendTail(sb);
            String string = sb.toString();
            return string;
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException iOException) {}
        }
    }

    protected static String streamToString(InputStream is) {
        Scanner s = new Scanner(is).useDelimiter("\\A");
        return s.hasNext() ? s.next() : "";
    }
}

