/*
 * Decompiled with CFR 0.152.
 */
package org.reveno.atp.clustering.core.components;

import java.nio.ByteBuffer;
import java.util.Queue;
import java.util.concurrent.LinkedTransferQueue;
import org.reveno.atp.core.api.channel.Buffer;
import org.reveno.atp.core.channel.NettyBasedBuffer;

public abstract class AbstractClusterBuffer {
    protected Buffer sendBuffer = new NettyBasedBuffer();
    protected Queue<Integer> sizeMarks = new LinkedTransferQueue<Integer>();

    public int readerPosition() {
        throw new UnsupportedOperationException();
    }

    public int limit() {
        throw new UnsupportedOperationException();
    }

    public int remaining() {
        throw new UnsupportedOperationException();
    }

    public void clear() {
    }

    public void release() {
    }

    public boolean isAvailable() {
        throw new UnsupportedOperationException();
    }

    public void setReaderPosition(int position) {
        throw new UnsupportedOperationException();
    }

    public ByteBuffer writeToBuffer() {
        return null;
    }

    public byte readByte() {
        throw new UnsupportedOperationException();
    }

    public byte[] readBytes(int length) {
        throw new UnsupportedOperationException();
    }

    public void readBytes(byte[] data, int offset, int length) {
        throw new UnsupportedOperationException();
    }

    public long readLong() {
        throw new UnsupportedOperationException();
    }

    public int readInt() {
        throw new UnsupportedOperationException();
    }

    public short readShort() {
        throw new UnsupportedOperationException();
    }

    public void markReader() {
        throw new UnsupportedOperationException();
    }

    public void resetReader() {
        throw new UnsupportedOperationException();
    }

    public void limitNext(int count) {
    }

    public void resetNextLimit() {
    }

    public int writerPosition() {
        return this.sendBuffer.writerPosition();
    }

    public long capacity() {
        return this.sendBuffer.capacity();
    }

    public int length() {
        return this.sendBuffer.length();
    }

    public void setWriterPosition(int position) {
        this.sendBuffer.setWriterPosition(position);
    }

    public void writeByte(byte b) {
        this.sendBuffer.writeByte(b);
    }

    public void writeBytes(byte[] bytes) {
        this.sendBuffer.writeBytes(bytes);
    }

    public void writeBytes(byte[] buffer, int offset, int count) {
        this.sendBuffer.writeBytes(buffer, offset, count);
    }

    public void writeLong(long value) {
        this.sendBuffer.writeLong(value);
    }

    public void writeInt(int value) {
        this.sendBuffer.writeInt(value);
    }

    public void writeShort(short s) {
        this.sendBuffer.writeShort(s);
    }

    public void writeFromBuffer(ByteBuffer buffer) {
        this.sendBuffer.writeFromBuffer(buffer);
    }

    public void resetWriter() {
        this.sendBuffer.resetWriter();
    }

    public void markWriter() {
        this.sendBuffer.markWriter();
    }

    public void markSize() {
        this.sizeMarks.add(this.sendBuffer.writerPosition());
        this.sendBuffer.writeInt(0);
    }

    public int sizeMarkPosition() {
        return this.sizeMarks.peek();
    }

    public void writeSize() {
        int pos = this.sendBuffer.writerPosition();
        this.sendBuffer.setWriterPosition(this.sizeMarks.poll().intValue());
        this.sendBuffer.writeInt(pos - this.sendBuffer.writerPosition() - 4);
        this.sendBuffer.setWriterPosition(pos);
    }
}

