/*
 * Decompiled with CFR 0.152.
 */
package org.reveno.atp.clustering.core.fastcast;

import java.lang.invoke.LambdaMetafactory;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.nustaq.fastcast.api.FCPublisher;
import org.nustaq.fastcast.api.FCSubscriber;
import org.nustaq.fastcast.api.FastCast;
import org.nustaq.fastcast.config.ClusterConf;
import org.nustaq.fastcast.config.PhysicalTransportConf;
import org.nustaq.fastcast.config.PublisherConf;
import org.nustaq.fastcast.config.SubscriberConf;
import org.nustaq.fastcast.config.TopicConf;
import org.nustaq.fastcast.impl.PacketSendBuffer;
import org.nustaq.fastcast.util.FCLog;
import org.nustaq.offheap.bytez.ByteSource;
import org.nustaq.offheap.bytez.Bytez;
import org.reveno.atp.clustering.api.Address;
import org.reveno.atp.clustering.api.ClusterBuffer;
import org.reveno.atp.clustering.api.ClusterEvent;
import org.reveno.atp.clustering.api.ClusterView;
import org.reveno.atp.clustering.core.components.AbstractClusterBuffer;
import org.reveno.atp.clustering.core.fastcast.ByteSourceBuffer;
import org.reveno.atp.clustering.core.fastcast.BytezBufferWrapper;
import org.reveno.atp.clustering.core.fastcast.FastCastConfiguration;
import org.reveno.atp.clustering.core.fastcast.FastCastEx;
import org.reveno.atp.clustering.core.fastcast.FastCastSlf4jLogger;
import org.reveno.atp.core.api.channel.Buffer;
import org.reveno.atp.core.api.serialization.TransactionInfoSerializer;
import org.reveno.atp.utils.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FastCastBuffer
extends AbstractClusterBuffer
implements ClusterBuffer {
    protected volatile ClusterView view;
    protected volatile boolean isEligableToSend = false;
    protected FastCast fastCast;
    protected FastCastConfiguration config;
    protected TransactionInfoSerializer serializer;
    protected Consumer<List<Object>> listener;
    protected Consumer<ClusterEvent> failoverNotifier;
    protected FCPublisher publisher;
    protected Set<String> senders = Collections.newSetFromMap(new ConcurrentHashMap());
    protected BytezBufferWrapper bytezBuffer = new BytezBufferWrapper();
    protected ByteSourceBuffer byteSource = new ByteSourceBuffer();
    protected static final Logger LOG = LoggerFactory.getLogger(FastCastBuffer.class);
    protected volatile boolean locked = false;

    @Override
    public void connect() {
        this.fastCast.onTransport(this.config.transportName()).subscribe(this.fastCast.getSubscriberConf(this.config.topicName()), new FCSubscriber(){

            public void messageReceived(String sender, long sequence, Bytez b, long off, int len) {
                try {
                    if (!FastCastBuffer.this.locked) {
                        FastCastBuffer.this.bytezBuffer.setBytez(b, off, len);
                        FastCastBuffer.this.listener.accept(FastCastBuffer.this.serializer.deserializeCommands((Buffer)FastCastBuffer.this.bytezBuffer));
                    }
                }
                catch (Throwable t) {
                    LOG.error("messageReceived", t);
                }
            }

            public boolean dropped() {
                LOG.info("FCST {}: dropped, failover mode enabled", (Object)FastCastBuffer.this.config.getCurrentNode().getNodeId());
                FastCastBuffer.this.locked = true;
                FastCastBuffer.this.failoverNotifier.accept(ClusterEvent.MEMBERSHIP_CHANGED);
                return true;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void senderTerminated(String senderNodeId) {
                LOG.info("FCST {}: member [{}] leaves.", (Object)FastCastBuffer.this.config.getCurrentNode().getNodeId(), (Object)senderNodeId);
                FastCastBuffer fastCastBuffer = FastCastBuffer.this;
                synchronized (fastCastBuffer) {
                    FastCastBuffer.this.senders.remove(senderNodeId);
                    FastCastBuffer.this.recalculateEligability(false);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void senderBootstrapped(String receivesFrom, long seqNo) {
                LOG.info("FCST {}: new member [{}] joins.", (Object)FastCastBuffer.this.config.getCurrentNode().getNodeId(), (Object)receivesFrom);
                FastCastBuffer fastCastBuffer = FastCastBuffer.this;
                synchronized (fastCastBuffer) {
                    FastCastBuffer.this.senders.add(receivesFrom);
                    FastCastBuffer.this.recalculateEligability(false);
                }
            }
        });
        this.publisher = this.fastCast.onTransport(this.config.transportName()).publish(this.fastCast.getPublisherConf(this.config.topicName()));
    }

    @Override
    public void disconnect() {
        this.publisher.flush();
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.fastCast.getTransportDriver(this.config.transportName()).terminate();
        this.fastCast.getTransport(this.config.transportName()).close();
        if (this.publisher instanceof PacketSendBuffer) {
            ((PacketSendBuffer)this.publisher).free();
        }
    }

    @Override
    public void onView(ClusterView view) {
        this.view = view;
        this.recalculateEligability(true);
    }

    @Override
    public void messageNotifier(TransactionInfoSerializer serializer, Consumer<List<Object>> listener) {
        this.serializer = serializer;
        this.listener = listener;
    }

    @Override
    public void failoverNotifier(Consumer<ClusterEvent> listener) {
        this.failoverNotifier = listener;
    }

    @Override
    public void lockIncoming() {
        this.locked = true;
    }

    @Override
    public void unlockIncoming() {
        this.locked = false;
    }

    @Override
    public void erase() {
    }

    @Override
    public void prepare() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean replicate() {
        try {
            if (!this.isEligableToSend) {
                boolean bl = false;
                return bl;
            }
            this.byteSource.setBuffer(this.sendBuffer);
            boolean res = false;
            for (int count = 0; !res && count < this.config.sendRetries(); ++count) {
                res = this.publisher().offer(null, (ByteSource)this.byteSource, 0L, this.sendBuffer.limit(), this.config.alwaysFlush());
            }
            if (LOG.isDebugEnabled() && !res) {
                LOG.warn("FCST: Can't send to FC!");
            }
            boolean bl = res;
            return bl;
        }
        finally {
            this.sendBuffer.clear();
        }
    }

    protected FCPublisher publisher() {
        return this.publisher;
    }

    /*
     * Unable to fully structure code
     */
    protected synchronized void recalculateEligability(boolean newView) {
        if (this.view == null) {
            this.isEligableToSend = false;
            return;
        }
        viewNodes = this.view.members().stream().map((Function<Address, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getNodeId(), (Lorg/reveno/atp/clustering/api/Address;)Ljava/lang/String;)()).collect(Collectors.toList());
        viewAddresses = this.config.getNodeAddresses().stream().filter((Predicate<Address>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$recalculateEligability$34(java.util.List org.reveno.atp.clustering.api.Address ), (Lorg/reveno/atp/clustering/api/Address;)Z)(viewNodes)).collect(Collectors.toList());
        if (newView) {
            this.senders.clear();
            this.senders.addAll((Collection<String>)viewAddresses.stream().map((Function<Address, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getNodeId(), (Lorg/reveno/atp/clustering/api/Address;)Ljava/lang/String;)()).collect(Collectors.toList()));
        }
        if (viewAddresses.size() != this.senders.size()) ** GOTO lbl-1000
        if (viewAddresses.stream().map((Function<Address, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getNodeId(), (Lorg/reveno/atp/clustering/api/Address;)Ljava/lang/String;)()).allMatch((Predicate<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, contains(java.lang.Object ), (Ljava/lang/String;)Z)(this.senders))) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = false;
        }
        this.isEligableToSend = v0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FastCastBuffer(FastCastConfiguration config) {
        try {
            Class<FCLog> clazz = FCLog.class;
            synchronized (FCLog.class) {
                FCLog.setInstance((FCLog)new FastCastSlf4jLogger());
                // ** MonitorExit[var2_2] (shouldn't be in output)
                this.fastCast = new FastCastEx();
                this.fastCast.setNodeId(config.getCurrentNode().getNodeId());
                PhysicalTransportConf transportConf = new PhysicalTransportConf();
                transportConf.setDgramsize(config.datagramSize());
                transportConf.ttl(config.socketConfiguration().ttl());
                transportConf.socketReceiveBufferSize(config.socketConfiguration().socketReceiveBufferSize());
                transportConf.socketSendBufferSize(config.socketConfiguration().socketSendBufferSize());
                transportConf.port(config.mcastPort());
                transportConf.mulitcastAdr(config.mcastHost());
                transportConf.interfaceAdr(config.networkInterface());
                transportConf.idleParkMicros(config.threadParkMicros());
                transportConf.setName(config.transportName());
                transportConf.spinLoopMicros(config.spinLoopMicros());
                PublisherConf publisherConf = new PublisherConf(1);
                publisherConf.heartbeatInterval(20L);
                publisherConf.numPacketHistory(config.retransmissionPacketHistory());
                publisherConf.pps(config.packetsPerSecond());
                publisherConf.ppsWindow(10);
                SubscriberConf subscriberConf = new SubscriberConf(1);
                subscriberConf.receiveBufferPackets(10000);
                TopicConf topicConf = new TopicConf().id(1);
                topicConf.name(config.topicName());
                topicConf.publisher(publisherConf);
                topicConf.subscriber(subscriberConf);
                ClusterConf clusterConf = new ClusterConf();
                clusterConf.transports(new PhysicalTransportConf[]{transportConf}).topics(new TopicConf[]{topicConf});
                this.fastCast.setConfig(clusterConf);
                this.config = config;
            }
        }
        catch (Throwable t) {
            throw Exceptions.runtime((Throwable)t);
        }
    }

    private static /* synthetic */ boolean lambda$recalculateEligability$34(List viewNodes, Address addressInConfig) {
        return viewNodes.contains(addressInConfig.getNodeId());
    }
}

