/*
 * Decompiled with CFR 0.152.
 */
package org.reveno.atp.metrics;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.reveno.atp.api.domain.WriteableRepository;
import org.reveno.atp.api.transaction.TransactionInterceptor;
import org.reveno.atp.api.transaction.TransactionStage;
import org.reveno.atp.metrics.ConfigurationImpl;
import org.reveno.atp.metrics.Sink;
import org.reveno.atp.metrics.impl.GraphiteSink;
import org.reveno.atp.metrics.impl.Slf4jSink;
import org.reveno.atp.metrics.meter.Counter;
import org.reveno.atp.metrics.meter.Histogram;
import org.reveno.atp.metrics.meter.impl.SimpleCounter;
import org.reveno.atp.metrics.meter.impl.TwoBufferHistogram;

public class MetricsInterceptor
implements TransactionInterceptor {
    protected long start = -1L;
    protected Counter counter;
    protected Histogram histogram;
    protected List<Sink> sinks = new ArrayList<Sink>();
    protected final String latency;
    protected final String throughput;
    protected final ConfigurationImpl config;
    protected final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();

    public void intercept(long transactionId, long time, WriteableRepository repository, TransactionStage stage) {
        if (stage == TransactionStage.REPLICATION) {
            this.counter.inc();
            this.histogram.update(System.nanoTime() - time);
        }
    }

    public void destroy() {
        if (!this.executor.isShutdown()) {
            this.executor.shutdown();
        }
    }

    public MetricsInterceptor(ConfigurationImpl config) {
        String prefix = "reveno.instances." + config.hostName().replace(".", "_") + "." + config.instanceName() + ".";
        this.latency = prefix + "latency";
        this.throughput = prefix + "throughput";
        this.config = config;
        this.counter = new SimpleCounter(this.throughput);
        this.histogram = new TwoBufferHistogram(this.latency, config.metricBufferSize());
    }

    public void init() {
        if (this.config.sendToGraphite()) {
            this.sinks.add(new GraphiteSink(this.config.graphiteServer(), this.config.graphitePort()));
        }
        if (this.config.sendToLog()) {
            this.sinks.add(new Slf4jSink());
        }
        this.sinks.forEach(Sink::init);
        this.executor.scheduleAtFixedRate(() -> {
            this.histogram.sendTo(this.sinks, true);
            this.counter.sendTo(this.sinks, true);
        }, 15L, 15L, TimeUnit.SECONDS);
    }

    public void shutdown() {
        this.sinks.forEach(Sink::close);
        if (this.histogram != null) {
            this.histogram.destroy();
        }
        this.executor.shutdown();
    }
}

