/*
 * Decompiled with CFR 0.152.
 */
package org.reveno.atp.metrics.impl;

import java.io.IOException;
import org.reveno.atp.metrics.Sink;
import org.reveno.atp.metrics.impl.PickledGraphite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphiteSink
implements Sink {
    protected final PickledGraphite graphite;
    protected static final Logger log = LoggerFactory.getLogger(GraphiteSink.class);

    @Override
    public void init() {
        try {
            this.graphite.connect();
        }
        catch (IOException | IllegalStateException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void send(String name, String value, long timestamp) {
        try {
            this.graphite.send(name, value, timestamp);
        }
        catch (IOException e) {
            log.error("", (Throwable)e);
        }
    }

    @Override
    public void close() {
        try {
            this.graphite.close();
        }
        catch (IOException e) {
            log.error("", (Throwable)e);
        }
    }

    @Override
    public boolean isAvailable() {
        return this.graphite.isConnected();
    }

    public GraphiteSink(String hostname, int port) {
        this.graphite = new PickledGraphite(hostname, port);
    }
}

