/*
 * Decompiled with CFR 0.152.
 */
package org.reveno.atp.metrics;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.reveno.atp.metrics.Configuration;
import org.reveno.atp.utils.MeasureUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationImpl
implements Configuration {
    protected boolean sendToGraphite = false;
    protected boolean sendToLog = true;
    protected String graphiteServer;
    protected int graphitePort = 2004;
    protected String instanceName = "default";
    protected String hostName;
    protected int metricBufferSize = MeasureUtils.kb((int)128);
    protected static final Logger log = LoggerFactory.getLogger(ConfigurationImpl.class);

    public boolean sendToGraphite() {
        return this.sendToGraphite;
    }

    @Override
    public Configuration sendToGraphite(boolean sendToGraphite) {
        this.sendToGraphite = sendToGraphite;
        return this;
    }

    public boolean sendToLog() {
        return this.sendToLog;
    }

    @Override
    public Configuration sendToLog(boolean sendToLog) {
        this.sendToLog = sendToLog;
        return this;
    }

    public String graphiteServer() {
        return this.graphiteServer;
    }

    @Override
    public Configuration graphiteServer(String graphiteServer) {
        this.graphiteServer = graphiteServer;
        return this;
    }

    public int graphitePort() {
        return this.graphitePort;
    }

    @Override
    public Configuration graphitePort(int graphitePort) {
        this.graphitePort = graphitePort;
        return this;
    }

    public String instanceName() {
        return this.instanceName;
    }

    @Override
    public Configuration instanceName(String instanceName) {
        this.instanceName = instanceName;
        return this;
    }

    public String hostName() {
        return this.hostName;
    }

    @Override
    public Configuration hostName(String hostName) {
        this.hostName = hostName;
        return this;
    }

    public int metricBufferSize() {
        return this.metricBufferSize;
    }

    @Override
    public Configuration metricBufferSize(int size) {
        this.metricBufferSize = size;
        return this;
    }

    public ConfigurationImpl() {
        try {
            this.hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }
}

