/*
 * Decompiled with CFR 0.152.
 */
package org.reveno.atp.metrics.meter.impl;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import org.reveno.atp.metrics.Sink;
import org.reveno.atp.metrics.meter.Histogram;
import org.reveno.atp.metrics.meter.HistogramType;
import org.reveno.atp.utils.UnsafeUtils;

public class TwoBufferHistogram
implements Histogram {
    protected static final int BITS_PER_LONG = 63;
    protected static final int BYTES_PER_LONG = 8;
    protected static final byte WRITING = 1;
    protected static final byte NEED_RESET = 2;
    protected static final byte RESET_DONE = 3;
    protected long prevMean = -1L;
    protected LongAdder count = new LongAdder();
    protected volatile int bit = 1;
    protected final String name;
    protected final ByteBuffer[] bufs;
    protected final int bufferSize;
    protected final int bufferCount = 2;
    protected final AtomicLong switcher = new AtomicLong();
    protected final HistogramType type;

    @Override
    public void sendTo(List<Sink> sinks, boolean sync) {
        this.switchNext(sync);
        ByteBuffer buffer = this.bufs[this.prevIndex()];
        long sum = this.count.sumThenReset();
        long amount = Math.min(sum, (long)(buffer.limit() / 8));
        long timestamp = System.currentTimeMillis() / 1000L;
        buffer.clear();
        long mean = 0L;
        long min = Long.MAX_VALUE;
        long max = 0L;
        long stddev = 0L;
        int count = 0;
        while (buffer.position() <= buffer.limit() && (long)(++count) <= amount) {
            long metric = buffer.getLong();
            mean += metric;
            if (metric > max) {
                max = metric;
            }
            if (metric < min) {
                min = metric;
            }
            if (this.prevMean == -1L) continue;
            stddev = (long)((double)stddev + Math.pow(this.prevMean - metric, 2.0));
        }
        mean /= (long)(count - 1);
        if (this.prevMean == -1L) {
            stddev = 0L;
        } else {
            stddev /= (long)count;
            stddev = (long)Math.sqrt(stddev);
        }
        this.prevMean = mean;
        for (Sink sink : sinks) {
            sink.send(this.name + ".count", Long.toString(sum), timestamp);
            sink.send(this.name + ".mean", Long.toString(mean), timestamp);
            sink.send(this.name + ".min", Long.toString(min), timestamp);
            sink.send(this.name + ".max", Long.toString(max), timestamp);
            sink.send(this.name + ".stddev", Long.toString(stddev), timestamp);
        }
        buffer.clear();
    }

    public void switchNext(boolean sync) {
        int nextIndex = (int)(this.switcher.incrementAndGet() % 2L);
        this.bit = nextIndex << 2 | 2;
        if (sync) {
            while (this.bit << 30 >>> 30 != 3) {
                Thread.yield();
            }
        }
    }

    @Override
    public Histogram update(long value) {
        this.count.increment();
        int currBit = this.bit;
        int currentIndex = currBit >> 2;
        ByteBuffer cur = this.bufs[currentIndex];
        if (currBit << 30 >>> 30 == 2) {
            this.bit = currentIndex << 2 | 3;
        }
        if (cur.remaining() > 0) {
            cur.putLong(value);
        } else if (this.type == HistogramType.RANDOM_VITTERS_R) {
            long next;
            while ((next = TwoBufferHistogram.nextLong(cur.limit())) > (long)(cur.limit() - 8)) {
            }
            int pos = (int)Math.round((double)next / 8.0) * 8;
            cur.position(pos);
            cur.putLong(value);
        }
        return this;
    }

    @Override
    public boolean isReady() {
        return this.bufs[this.bit >> 2].remaining() == 0;
    }

    public void destroy() {
        UnsafeUtils.destroyDirectBuffer((ByteBuffer)this.bufs[0]);
        UnsafeUtils.destroyDirectBuffer((ByteBuffer)this.bufs[1]);
    }

    protected int currentIndex() {
        return (int)(this.switcher.get() % 2L);
    }

    protected int prevIndex() {
        if (this.currentIndex() == 1) {
            return 0;
        }
        return 1;
    }

    protected static long nextLong(long n) {
        long val;
        long bits;
        while ((bits = ThreadLocalRandom.current().nextLong() & Long.MAX_VALUE) - (val = bits % n) + (n - 1L) < 0L) {
        }
        return val;
    }

    public TwoBufferHistogram(String name, int bufferSize) {
        this(name, bufferSize, HistogramType.RANDOM_VITTERS_R);
    }

    public TwoBufferHistogram(String name, int bufferSize, HistogramType type) {
        if (Integer.bitCount(bufferSize) != 1) {
            throw new IllegalArgumentException("Buffer size must be pow(2, n) number!");
        }
        this.bufferSize = bufferSize;
        this.bufs = new ByteBuffer[2];
        for (int i = 0; i < 2; ++i) {
            this.bufs[i] = ByteBuffer.allocateDirect(bufferSize);
        }
        this.type = type;
        this.name = name;
    }
}

