/*
 * Decompiled with CFR 0.152.
 */
package org.reveno.atp.metrics.impl;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import javax.net.SocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PickledGraphite {
    private static final Pattern WHITESPACE = Pattern.compile("[\\s]+");
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final Logger LOGGER = LoggerFactory.getLogger(PickledGraphite.class);
    private static final int DEFAULT_BATCH_SIZE = 100;
    private int batchSize;
    private List<MetricTuple> metrics = new LinkedList<MetricTuple>();
    private final String hostname;
    private final int port;
    private final InetSocketAddress address;
    private final SocketFactory socketFactory;
    private final Charset charset;
    private Socket socket;
    private Writer writer;
    private int failures;
    private final char MARK = (char)40;
    private final char STOP = (char)46;
    private final char LONG = (char)76;
    private final char STRING = (char)83;
    private final char APPEND = (char)97;
    private final char LIST = (char)108;
    private final char TUPLE = (char)116;
    private final char QUOTE = (char)39;
    private final char LF = (char)10;

    public PickledGraphite(InetSocketAddress address) {
        this(address, 100);
    }

    public PickledGraphite(InetSocketAddress address, int batchSize) {
        this(address, SocketFactory.getDefault(), batchSize);
    }

    public PickledGraphite(InetSocketAddress address, SocketFactory socketFactory, int batchSize) {
        this(address, socketFactory, UTF_8, batchSize);
    }

    public PickledGraphite(InetSocketAddress address, SocketFactory socketFactory, Charset charset, int batchSize) {
        this.address = address;
        this.hostname = null;
        this.port = -1;
        this.socketFactory = socketFactory;
        this.charset = charset;
        this.batchSize = batchSize;
    }

    public PickledGraphite(String hostname, int port) {
        this(hostname, port, 100);
    }

    public PickledGraphite(String hostname, int port, int batchSize) {
        this(hostname, port, SocketFactory.getDefault(), batchSize);
    }

    public PickledGraphite(String hostname, int port, SocketFactory socketFactory, int batchSize) {
        this(hostname, port, socketFactory, UTF_8, batchSize);
    }

    public PickledGraphite(String hostname, int port, SocketFactory socketFactory, Charset charset, int batchSize) {
        this.address = null;
        this.hostname = hostname;
        this.port = port;
        this.socketFactory = socketFactory;
        this.charset = charset;
        this.batchSize = batchSize;
    }

    public void connect() throws IllegalStateException, IOException {
        if (this.isConnected()) {
            throw new IllegalStateException("Already connected");
        }
        InetSocketAddress address = this.address;
        if (address == null) {
            address = new InetSocketAddress(this.hostname, this.port);
        }
        if (address.getAddress() == null) {
            throw new UnknownHostException(address.getHostName());
        }
        this.socket = this.socketFactory.createSocket(address.getAddress(), address.getPort());
        this.writer = new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream(), this.charset));
    }

    public boolean isConnected() {
        return this.socket != null && this.socket.isConnected() && !this.socket.isClosed();
    }

    public void send(String name, String value, long timestamp) throws IOException {
        this.metrics.add(new MetricTuple(this.sanitize(name), timestamp, this.sanitize(value)));
        if (this.metrics.size() >= this.batchSize) {
            this.writeMetrics();
        }
    }

    public void flush() throws IOException {
        this.writeMetrics();
        if (this.writer != null) {
            this.writer.flush();
        }
    }

    public void close() throws IOException {
        try {
            this.flush();
            if (this.writer != null) {
                this.writer.close();
            }
        }
        catch (IOException ex) {
            if (this.socket != null) {
                this.socket.close();
            }
        }
        finally {
            this.socket = null;
            this.writer = null;
        }
    }

    public int getFailures() {
        return this.failures;
    }

    private void writeMetrics() throws IOException {
        if (this.metrics.size() > 0) {
            try {
                byte[] payload = this.pickleMetrics(this.metrics);
                byte[] header = ByteBuffer.allocate(4).putInt(payload.length).array();
                OutputStream outputStream = this.socket.getOutputStream();
                outputStream.write(header);
                outputStream.write(payload);
                outputStream.flush();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Wrote {} metrics", (Object)this.metrics.size());
                }
            }
            catch (IOException e) {
                ++this.failures;
                throw e;
            }
            finally {
                this.metrics.clear();
            }
        }
    }

    byte[] pickleMetrics(List<MetricTuple> metrics) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(metrics.size() * 75);
        OutputStreamWriter pickled = new OutputStreamWriter((OutputStream)out, this.charset);
        pickled.append('(');
        pickled.append('l');
        for (MetricTuple tuple : metrics) {
            pickled.append('(');
            pickled.append('S');
            pickled.append('\'');
            ((Writer)pickled).append(tuple.name);
            pickled.append('\'');
            pickled.append('\n');
            pickled.append('(');
            pickled.append('L');
            ((Writer)pickled).append(Long.toString(tuple.timestamp));
            pickled.append('L');
            pickled.append('\n');
            pickled.append('S');
            pickled.append('\'');
            ((Writer)pickled).append(tuple.value);
            pickled.append('\'');
            pickled.append('\n');
            pickled.append('t');
            pickled.append('t');
            pickled.append('a');
        }
        pickled.append('.');
        ((Writer)pickled).flush();
        return out.toByteArray();
    }

    protected String sanitize(String s) {
        return WHITESPACE.matcher(s).replaceAll("-");
    }

    static class MetricTuple {
        String name;
        long timestamp;
        String value;

        MetricTuple(String name, long timestamp, String value) {
            this.name = name;
            this.timestamp = timestamp;
            this.value = value;
        }
    }
}

