/*
 * Decompiled with CFR 0.152.
 */
package org.reveno.atp.metrics.meter.impl;

import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.reveno.atp.metrics.Sink;
import org.reveno.atp.metrics.meter.Counter;

public class SimpleCounter
implements Counter {
    protected String name;
    protected long lastTime = System.currentTimeMillis();
    protected final AtomicLong counter = new AtomicLong();

    @Override
    public void sendTo(List<Sink> sinks, boolean sync) {
        long count = this.counter.getAndSet(0L);
        long current = System.currentTimeMillis();
        long interval = (current - this.lastTime) / 1000L;
        if (interval > 0L) {
            for (long i = this.lastTime; i <= current; i += 1000L) {
                for (Sink s : sinks) {
                    s.send(this.name + ".hits", Long.toString(count / interval), i / 1000L);
                }
            }
        }
        this.lastTime = current;
    }

    @Override
    public void inc(long i) {
        this.counter.addAndGet(i);
    }

    @Override
    public void inc(int i) {
        this.inc((long)i);
    }

    @Override
    public void inc() {
        this.counter.incrementAndGet();
    }

    public SimpleCounter(String name) {
        this.name = name;
    }
}

