package org.rewedigital.dialog.spring.annotations

import org.springframework.stereotype.Component

/**
 * Indicates that this class is an [FallbackIntentHandler] and implements the
 * [org.rewedigital.dialog.handler.DialogflowIntentHandler] interface.
 *
 * [FallbackIntentHandler] has the [Component] Annotation and will be autogenerated by Spring.
 * The [FallbackIntentHandler] is a special kind of [IntentHandler] witch will be triggered
 * if the [org.rewedigital.dialog.resolver.RequestResolver] can't find a matching [IntentHandler]
 * for the incoming request. The [org.rewedigital.dialog.handler.DialogflowIntentHandler.canHandleDialogflowIntent]
 * method will be ignored then.
 */
@Target(AnnotationTarget.CLASS, AnnotationTarget.TYPE)
@Retention(AnnotationRetention.RUNTIME)
@Component
annotation class FallbackIntentHandler