package org.rewedigital.dialog.spring.annotations

import org.springframework.stereotype.Component

/**
 * Indicates that this class is an [IntentHandler] and implements the
 * [org.rewedigital.dialog.handler.DialogflowIntentHandler] interface.
 *
 * [IntentHandler] has the [Component] Annotation and will be autogenerated by Spring.
 * All found [IntentHandler] will be added to the [org.rewedigital.dialog.resolver.RequestResolver]
 * witch will route incoming requests to the right [IntentHandler].
 */
@Target(AnnotationTarget.CLASS, AnnotationTarget.TYPE)
@Retention(AnnotationRetention.RUNTIME)
@Component
annotation class IntentHandler