package org.rewedigital.dialog.spring.annotations

import org.springframework.stereotype.Component

/**
 * Indicates that this class is an [Interceptor] with must implement on of
 * [org.rewedigital.dialog.interceptors.RequestInterceptor], [org.rewedigital.dialog.interceptors.ResponseInterceptor]
 * or both.
 *
 * [Interceptor] has the [Component] annotation and will be autogenerated by Spring.
 *
 * All found [Interceptor] will be called from the [org.rewedigital.dialog.resolver.RequestResolver]
 * witch will call all [org.rewedigital.dialog.interceptors.RequestInterceptor] for incoming requests and and
 * all [org.rewedigital.dialog.interceptors.ResponseInterceptor] for outgoing requests.
 */
@Target(AnnotationTarget.CLASS, AnnotationTarget.TYPE)
@Retention(AnnotationRetention.RUNTIME)
@Component
annotation class Interceptor