/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.whatswrong;

import com.googlecode.whatswrong.CorpusLoader;
import com.googlecode.whatswrong.Edge;
import com.googlecode.whatswrong.EdgeTypeFilter;
import com.googlecode.whatswrong.NLPCanvas;
import com.googlecode.whatswrong.NLPDiff;
import com.googlecode.whatswrong.NLPInstance;
import com.googlecode.whatswrong.SimpleGridBagConstraints;
import com.googlecode.whatswrong.Token;
import com.googlecode.whatswrong.TokenProperty;
import com.googlecode.whatswrong.javautils.Pair;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.WhitespaceAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.highlight.Highlighter;
import org.apache.lucene.search.highlight.QueryScorer;
import org.apache.lucene.search.highlight.Scorer;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CorpusNavigator
extends JPanel
implements CorpusLoader.Listener {
    private CorpusLoader guess;
    private CorpusLoader gold;
    private NLPCanvas canvas;
    private JSpinner spinner;
    private SpinnerNumberModel numberModel;
    private HashMap<List<NLPInstance>, IndexSearcher> indices = new HashMap();
    private HashMap<Pair<List<NLPInstance>, List<NLPInstance>>, List<NLPInstance>> diffCorpora = new HashMap();
    private HashSet<List<NLPInstance>> goldCorpora = new HashSet();
    private HashSet<List<NLPInstance>> guessCorpora = new HashSet();
    private IndexSearcher indexSearcher;
    private Analyzer analyzer;
    private JButton searchButton;
    private JList results;
    private JTextField search;
    private NLPDiff diff = new NLPDiff();
    private JPanel spinnerPanel;
    private JLabel ofHowMany;
    private EdgeTypeFilter edgeTypeFilter;

    @Override
    public void corpusAdded(List<NLPInstance> corpus, CorpusLoader src) {
        if (src == this.gold) {
            this.goldCorpora.add(corpus);
        } else {
            this.guessCorpora.add(corpus);
        }
    }

    private List<NLPInstance> getDiffCorpus(List<NLPInstance> gold, List<NLPInstance> guess) {
        List<NLPInstance> diffCorpus = this.diffCorpora.get(new Pair<List<NLPInstance>, List<NLPInstance>>(gold, guess));
        if (diffCorpus == null) {
            diffCorpus = new ArrayList<NLPInstance>(Math.min(gold.size(), guess.size()));
            this.diffCorpora.put(new Pair<List<NLPInstance>, List<NLPInstance>>(gold, guess), diffCorpus);
            for (int i = 0; i < Math.min(gold.size(), guess.size()); ++i) {
                diffCorpus.add(this.diff.diff(gold.get(i), guess.get(i)));
            }
        }
        return diffCorpus;
    }

    private void removeDiffCorpus(List<NLPInstance> gold, List<NLPInstance> guess) {
        Pair<List<NLPInstance>, List<NLPInstance>> pair = new Pair<List<NLPInstance>, List<NLPInstance>>(gold, guess);
        List<NLPInstance> diffCorpus = this.diffCorpora.get(pair);
        if (diffCorpus != null) {
            this.diffCorpora.remove(pair);
            this.indices.remove(diffCorpus);
        }
    }

    @Override
    public void corpusRemoved(List<NLPInstance> corpus, CorpusLoader src) {
        if (src == this.gold) {
            this.goldCorpora.remove(corpus);
            this.indices.remove(corpus);
            for (List<NLPInstance> c : this.guessCorpora) {
                this.removeDiffCorpus(corpus, c);
            }
        } else {
            this.guessCorpora.remove(corpus);
            this.indices.remove(corpus);
            for (List<NLPInstance> c : this.goldCorpora) {
                this.removeDiffCorpus(corpus, c);
            }
        }
    }

    @Override
    public synchronized void corpusSelected(List<NLPInstance> corpus, CorpusLoader src) {
        this.updateCanvas();
        this.results.setModel(new DefaultListModel());
    }

    public CorpusNavigator(NLPCanvas canvas, CorpusLoader goldLoader, CorpusLoader guessLoader, EdgeTypeFilter edgeTypeFilter) {
        super(new GridBagLayout());
        this.edgeTypeFilter = edgeTypeFilter;
        this.guess = guessLoader;
        this.gold = goldLoader;
        this.canvas = canvas;
        guessLoader.addChangeListener(this);
        goldLoader.addChangeListener(this);
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.numberModel = new SpinnerNumberModel();
        this.numberModel.setMinimum(Integer.valueOf(0));
        this.numberModel.setMaximum(Integer.valueOf(100));
        this.spinner = new JSpinner(this.numberModel);
        this.spinner.setEnabled(false);
        JSpinner.NumberEditor numberEditor = new JSpinner.NumberEditor(this.spinner);
        this.spinner.setEditor(numberEditor);
        this.spinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                CorpusNavigator.this.updateCanvas();
            }
        });
        final JFormattedTextField editorTextField = numberEditor.getTextField();
        editorTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    CorpusNavigator.this.spinner.setValue(Integer.valueOf(editorTextField.getText()));
                }
                catch (NumberFormatException ex) {
                    CorpusNavigator.this.spinner.setValue(editorTextField.getValue());
                }
            }
        });
        this.spinnerPanel = new JPanel();
        this.spinnerPanel.setLayout(new BoxLayout(this.spinnerPanel, 0));
        this.spinnerPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.spinnerPanel.add(this.spinner);
        this.ofHowMany = new JLabel(" of 1");
        this.spinnerPanel.add(this.ofHowMany);
        this.search = new JTextField(10);
        this.search.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CorpusNavigator.this.searchCorpus();
            }
        });
        this.searchButton = new JButton("Search");
        JPanel searchPanel = new JPanel(new BorderLayout());
        searchPanel.add((Component)this.search, "Center");
        searchPanel.add((Component)this.searchButton, "East");
        this.searchButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CorpusNavigator.this.searchCorpus();
            }
        });
        this.results = new JList();
        this.results.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                int selectedIndex = CorpusNavigator.this.results.getSelectedIndex();
                if (selectedIndex != -1) {
                    int nr = ((Result)((CorpusNavigator)CorpusNavigator.this).results.getSelectedValue()).nr;
                    CorpusNavigator.this.spinner.setValue(nr);
                    CorpusNavigator.this.repaint();
                }
            }
        });
        this.add((Component)searchPanel, new SimpleGridBagConstraints(0, 0, 2, 1));
        JScrollPane resultsPane = new JScrollPane(this.results);
        resultsPane.setMinimumSize(new Dimension(100, 10));
        this.add((Component)resultsPane, new SimpleGridBagConstraints(0, 1, 2, 2));
        this.analyzer = new WhitespaceAnalyzer();
        this.updateCanvas();
    }

    public JPanel getSpinnerPanel() {
        return this.spinnerPanel;
    }

    private void searchCorpus() {
        if (this.search.getText().trim().equals("")) {
            return;
        }
        try {
            this.indexSearcher = this.guess.getSelected() != null ? this.getIndex(this.getDiffCorpus(this.gold.getSelected(), this.guess.getSelected())) : this.getIndex(this.gold.getSelected());
            QueryParser parser = new QueryParser("Word", this.analyzer);
            Query query = parser.parse(this.search.getText());
            Hits hits = this.indexSearcher.search(query);
            Highlighter highlighter = new Highlighter((Scorer)new QueryScorer(query));
            DefaultListModel<Result> model = new DefaultListModel<Result>();
            for (int i = 0; i < hits.length(); ++i) {
                Object field;
                Field f;
                Document hitDoc = hits.doc(i);
                int nr = Integer.parseInt(hitDoc.get("<nr>"));
                String best = null;
                Iterator i$ = hitDoc.getFields().iterator();
                while (i$.hasNext() && (best = highlighter.getBestFragment(this.analyzer, (f = (Field)(field = i$.next())).name(), hitDoc.get(f.name()))) == null) {
                }
                if (best == null) continue;
                model.addElement(new Result(nr, "<html>" + nr + ":" + best + "</html>"));
            }
            this.results.setModel(model);
            this.repaint();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private synchronized IndexSearcher getIndex(List<NLPInstance> corpus) {
        IndexSearcher index = this.indices.get(corpus);
        if (index == null) {
            index = this.createIndex(corpus);
            this.indices.put(corpus, index);
        }
        return index;
    }

    private IndexSearcher createIndex(List<NLPInstance> corpus) {
        try {
            System.err.println("Creating Index");
            RAMDirectory directory = new RAMDirectory();
            IndexWriter iwriter = new IndexWriter((Directory)directory, this.analyzer, true);
            iwriter.setMaxFieldLength(25000);
            int nr = 0;
            for (NLPInstance instance : corpus) {
                Document doc = new Document();
                LinkedHashMap<TokenProperty, StringBuffer> sentences = new LinkedHashMap<TokenProperty, StringBuffer>();
                for (Token token : instance.getTokens()) {
                    for (TokenProperty p : token.getPropertyTypes()) {
                        StringBuffer buffer = (StringBuffer)((HashMap)sentences).get(p);
                        if (buffer == null) {
                            buffer = new StringBuffer();
                            sentences.put(p, buffer);
                        }
                        if (token.getIndex() > 0) {
                            buffer.append(" ");
                        }
                        buffer.append(token.getProperty(p));
                    }
                }
                for (TokenProperty p : ((HashMap)sentences).keySet()) {
                    doc.add((Fieldable)new Field(p.getName(), ((StringBuffer)((HashMap)sentences).get(p)).toString(), Field.Store.YES, Field.Index.TOKENIZED));
                }
                HashMap<String, StringBuffer> edges = new HashMap<String, StringBuffer>();
                StringBuffer types = new StringBuffer();
                for (Edge e : instance.getEdges()) {
                    String prefix = e.getTypePrefix();
                    StringBuffer prefixBuffer = (StringBuffer)edges.get(prefix);
                    types.append(prefix).append(" ");
                    if (prefixBuffer == null) {
                        prefixBuffer = new StringBuffer();
                        edges.put(prefix, prefixBuffer);
                    }
                    prefixBuffer.append(e.getLabel()).append(" ");
                    String postfix = e.getTypePostfix();
                    if (postfix == null) continue;
                    types.append(postfix).append(" ");
                    StringBuffer postfixBuffer = (StringBuffer)edges.get(postfix);
                    if (postfixBuffer == null) {
                        postfixBuffer = new StringBuffer();
                        edges.put(postfix, postfixBuffer);
                    }
                    postfixBuffer.append(e.getLabel()).append(" ");
                }
                doc.add((Fieldable)new Field("types", types.toString(), Field.Store.YES, Field.Index.TOKENIZED));
                for (String type : edges.keySet()) {
                    doc.add((Fieldable)new Field(type, ((StringBuffer)edges.get(type)).toString(), Field.Store.YES, Field.Index.TOKENIZED));
                }
                doc.add((Fieldable)new Field("<nr>", String.valueOf(nr), Field.Store.YES, Field.Index.UN_TOKENIZED));
                System.err.print(".");
                iwriter.addDocument(doc);
                ++nr;
            }
            System.err.println();
            iwriter.optimize();
            iwriter.close();
            return new IndexSearcher((Directory)directory);
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't build the index");
        }
    }

    private void updateCanvas() {
        if (this.gold.getSelected() != null) {
            this.searchButton.setEnabled(true);
            this.search.setEnabled(true);
            this.spinner.setEnabled(true);
            this.results.setEnabled(true);
            if (this.guess.getSelected() == null) {
                int maxIndex = this.gold.getSelected().size() - 1;
                int index = Math.min((Integer)this.spinner.getValue(), maxIndex);
                this.spinner.setValue(index);
                this.numberModel.setMaximum(Integer.valueOf(maxIndex));
                this.ofHowMany.setText(" of " + maxIndex);
                this.indexSearcher = this.getIndex(this.gold.getSelected());
                this.canvas.setNLPInstance(this.gold.getSelected().get(index));
                this.canvas.updateNLPGraphics();
            } else {
                int maxIndex = Math.min(this.gold.getSelected().size() - 1, this.guess.getSelected().size() - 1);
                this.numberModel.setMaximum(Integer.valueOf(maxIndex));
                int index = Math.min((Integer)this.spinner.getValue(), maxIndex);
                this.spinner.setValue(index);
                this.ofHowMany.setText(" of " + maxIndex);
                NLPInstance instance = this.getDiffCorpus(this.gold.getSelected(), this.guess.getSelected()).get(index);
                this.canvas.getRenderer().setEdgeTypeColor("FN", Color.BLUE);
                this.canvas.getRenderer().setEdgeTypeColor("FP", Color.RED);
                this.canvas.setNLPInstance(instance);
                this.canvas.updateNLPGraphics();
            }
        } else {
            this.searchButton.setEnabled(false);
            this.search.setEnabled(false);
            this.spinner.setEnabled(false);
            this.spinner.setValue(0);
            this.searchButton.setEnabled(false);
            this.results.setEnabled(false);
            this.ofHowMany.setText(" of 1");
            NLPInstance example = new NLPInstance();
            example.addToken().addProperty("Word", "[root]").addProperty("Index", "0");
            example.addToken().addProperty("Word", "Add").addProperty("Index", "1");
            example.addToken().addProperty("Word", "a").addProperty("Index", "2");
            example.addToken().addProperty("Word", "gold").addProperty("Index", "3");
            example.addToken().addProperty("Word", "corpus").addProperty("Index", "4");
            example.addToken().addProperty("Word", "!").addProperty("Index", "5");
            example.addDependency(0, 1, "ROOT", "dep");
            example.addDependency(0, 5, "PUNC", "dep");
            example.addDependency(1, 4, "OBJ", "dep");
            example.addDependency(4, 2, "DET", "dep");
            example.addDependency(4, 3, "MOD", "dep");
            example.addDependency(1, 4, "A1", "role");
            example.addSpan(1, 1, "add.1", "sense");
            this.canvas.setNLPInstance(example);
            this.edgeTypeFilter.addAllowedPrefixType("dep");
            this.edgeTypeFilter.addAllowedPrefixType("role");
            this.edgeTypeFilter.addAllowedPrefixType("sense");
            this.edgeTypeFilter.addAllowedPrefixType("ner");
            this.edgeTypeFilter.addAllowedPrefixType("chunk");
            this.edgeTypeFilter.addAllowedPrefixType("pos");
            this.edgeTypeFilter.addAllowedPrefixType("align");
            this.edgeTypeFilter.addAllowedPostfixType("FP");
            this.edgeTypeFilter.addAllowedPostfixType("FN");
            this.edgeTypeFilter.addAllowedPostfixType("Match");
            this.canvas.getRenderer().setEdgeTypeOrder("pos", 0);
            this.canvas.getRenderer().setEdgeTypeOrder("chunk (BIO)", 1);
            this.canvas.getRenderer().setEdgeTypeOrder("chunk", 2);
            this.canvas.getRenderer().setEdgeTypeOrder("ner (BIO)", 2);
            this.canvas.getRenderer().setEdgeTypeOrder("ner", 3);
            this.canvas.getRenderer().setEdgeTypeOrder("sense", 4);
            this.canvas.getRenderer().setEdgeTypeOrder("role", 5);
            this.canvas.getRenderer().setEdgeTypeOrder("phrase", 5);
            this.canvas.updateNLPGraphics();
        }
    }

    private static class Result {
        public final String text;
        public final int nr;

        public Result(int nr, String text) {
            this.text = text;
            this.nr = nr;
        }

        public String toString() {
            return this.text;
        }
    }
}

