/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.whatswrong;

import com.googlecode.whatswrong.Token;

public class Edge {
    private Token from;
    private Token to;
    private String label;
    private String description = "No Description";
    private String note;
    private String type;
    private RenderType renderType = RenderType.dependency;

    public Edge(Token from, Token to, String label, String type, RenderType renderType) {
        this.from = from;
        this.to = to;
        this.label = label;
        this.type = type;
        this.renderType = renderType;
    }

    public Edge(Token from, Token to, String label, String note, String type, RenderType renderType) {
        this.from = from;
        this.to = to;
        this.label = label;
        this.type = type;
        this.renderType = renderType;
        this.note = note;
    }

    public Edge(Token from, Token to, String label, String note, String type, RenderType renderType, String description) {
        this.from = from;
        this.to = to;
        this.label = label;
        this.type = type;
        this.renderType = renderType;
        this.note = note;
        this.description = description;
    }

    public Edge(Token from, Token to, String label, String type) {
        this.from = from;
        this.to = to;
        this.label = label;
        this.type = type;
    }

    public String getTypePrefix() {
        int index = this.type.indexOf(58);
        return index == -1 ? this.type : this.type.substring(0, index);
    }

    public String getTypePostfix() {
        int index = this.type.indexOf(58);
        return index == -1 ? "" : this.type.substring(index + 1);
    }

    public String getDescription() {
        return this.description;
    }

    public int getMinIndex() {
        return this.from.getIndex() < this.to.getIndex() ? this.from.getIndex() : this.to.getIndex();
    }

    public int getMaxIndex() {
        return this.from.getIndex() > this.to.getIndex() ? this.from.getIndex() : this.to.getIndex();
    }

    public RenderType getRenderType() {
        return this.renderType;
    }

    public void setRenderType(RenderType renderType) {
        this.renderType = renderType;
    }

    public Token getFrom() {
        return this.from;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Token getTo() {
        return this.to;
    }

    public String getLabel() {
        return this.label;
    }

    public String getNote() {
        return this.note;
    }

    public String getLabelWithNote() {
        return this.label + (this.note == null ? "" : "(" + this.note + ")");
    }

    public String getType() {
        return this.type;
    }

    public int lexicographicOrder(Edge edge) {
        int result = this.type.compareTo(edge.type);
        if (result == 0 && (result = -this.label.compareTo(edge.label)) == 0 && this.note != null) {
            result = -this.note.compareTo(edge.note);
        }
        return result;
    }

    public boolean leftOf(Token token) {
        return this.from.getIndex() <= token.getIndex() && this.to.getIndex() <= token.getIndex();
    }

    public boolean rightOf(Token token) {
        return this.from.getIndex() >= token.getIndex() && this.to.getIndex() >= token.getIndex();
    }

    public int getLength() {
        return Math.abs(this.from.getIndex() - this.to.getIndex());
    }

    public boolean covers(Edge edge) {
        return this.getMinIndex() < edge.getMinIndex() && this.getMaxIndex() > edge.getMaxIndex();
    }

    public boolean coversExactly(Edge edge) {
        return this.getMinIndex() == edge.getMinIndex() && this.getMaxIndex() == edge.getMaxIndex();
    }

    public boolean coversSemi(Edge edge) {
        return this.getMinIndex() < edge.getMinIndex() && this.getMaxIndex() == edge.getMaxIndex() || this.getMinIndex() == edge.getMinIndex() && this.getMaxIndex() > edge.getMaxIndex();
    }

    public boolean overlaps(Edge edge) {
        return this.getMinIndex() <= edge.getMinIndex() && this.getMaxIndex() <= edge.getMaxIndex() && this.getMaxIndex() >= edge.getMinIndex() || this.getMinIndex() >= edge.getMinIndex() && this.getMaxIndex() <= edge.getMaxIndex() && this.getMaxIndex() <= edge.getMinIndex();
    }

    public boolean strictlyCovers(Edge edge) {
        return this.getMinIndex() < edge.getMinIndex() && this.getMaxIndex() >= edge.getMaxIndex() || this.getMinIndex() <= edge.getMinIndex() && this.getMaxIndex() > edge.getMaxIndex();
    }

    public String toString() {
        return this.from.getIndex() + "-" + this.label + "->" + this.to.getIndex() + "(" + this.type + ")";
    }

    public boolean crosses(Edge edge) {
        return this.getMinIndex() > edge.getMinIndex() && this.getMinIndex() < edge.getMaxIndex() && this.getMaxIndex() > edge.getMaxIndex() || edge.getMinIndex() > this.getMinIndex() && edge.getMinIndex() < this.getMaxIndex() && edge.getMaxIndex() > this.getMaxIndex();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Edge that = (Edge)o;
        if (this.from != null ? !this.from.equals(that.from) : that.from != null) {
            return false;
        }
        if (this.label != null ? !this.label.equals(that.label) : that.label != null) {
            return false;
        }
        if (this.to != null ? !this.to.equals(that.to) : that.to != null) {
            return false;
        }
        if (this.type != null ? !this.type.equals(that.type) : that.type != null) {
            return false;
        }
        return !(this.note != null ? !this.note.equals(that.note) : that.note != null);
    }

    public int hashCode() {
        int result = this.from != null ? this.from.hashCode() : 0;
        result = 31 * result + (this.to != null ? this.to.hashCode() : 0);
        result = 31 * result + (this.label != null ? this.label.hashCode() : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.note != null ? this.note.hashCode() : 0);
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RenderType {
        span,
        dependency;

    }
}

