/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.whatswrong;

import com.googlecode.whatswrong.Edge;
import com.googlecode.whatswrong.EdgeFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EdgeLabelFilter
extends EdgeFilter {
    private HashSet<String> allowedLabels = new HashSet();

    public EdgeLabelFilter(String ... allowedLabels) {
        this.allowedLabels.addAll(Arrays.asList(allowedLabels));
    }

    public void addAllowedLabel(String label) {
        this.allowedLabels.add(label);
    }

    public void removeAllowedLabel(String label) {
        this.allowedLabels.remove(label);
    }

    public EdgeLabelFilter(Set<String> allowedLabels) {
        this.allowedLabels.addAll(allowedLabels);
    }

    public void clear() {
        this.allowedLabels.clear();
    }

    @Override
    public Collection<Edge> filterEdges(Collection<Edge> original) {
        if (this.allowedLabels.size() == 0) {
            return original;
        }
        ArrayList<Edge> result = new ArrayList<Edge>(original.size());
        block0: for (Edge edge : original) {
            for (String allowed : this.allowedLabels) {
                if (!edge.getLabel().contains(allowed)) continue;
                result.add(edge);
                continue block0;
            }
        }
        return result;
    }

    public boolean allows(String label) {
        return this.allowedLabels.contains(label);
    }
}

